package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyDevice invokes the cloudauth.VerifyDevice API synchronously
func (client *Client) VerifyDevice(request *VerifyDeviceRequest) (response *VerifyDeviceResponse, err error) {
	response = CreateVerifyDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyDeviceWithChan invokes the cloudauth.VerifyDevice API asynchronously
func (client *Client) VerifyDeviceWithChan(request *VerifyDeviceRequest) (<-chan *VerifyDeviceResponse, <-chan error) {
	responseChan := make(chan *VerifyDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyDeviceWithCallback invokes the cloudauth.VerifyDevice API asynchronously
func (client *Client) VerifyDeviceWithCallback(request *VerifyDeviceRequest, callback func(response *VerifyDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyDeviceResponse
		var err error
		defer close(result)
		response, err = client.VerifyDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyDeviceRequest is the request struct for api VerifyDevice
type VerifyDeviceRequest struct {
	*requests.RpcRequest
	ExtInfo     string `position:"Body" name:"ExtInfo"`
	CertifyData string `position:"Query" name:"CertifyData"`
	AppVersion  string `position:"Query" name:"AppVersion"`
	DeviceToken string `position:"Body" name:"DeviceToken"`
	CertifyId   string `position:"Query" name:"CertifyId"`
}

// VerifyDeviceResponse is the response struct for api VerifyDevice
type VerifyDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateVerifyDeviceRequest creates a request to invoke VerifyDevice API
func CreateVerifyDeviceRequest() (request *VerifyDeviceRequest) {
	request = &VerifyDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "VerifyDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateVerifyDeviceResponse creates a response to parse from VerifyDevice response
func CreateVerifyDeviceResponse() (response *VerifyDeviceResponse) {
	response = &VerifyDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
