package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryResDistribute invokes the cloudcallcenter.QueryResDistribute API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryresdistribute.html
func (client *Client) QueryResDistribute(request *QueryResDistributeRequest) (response *QueryResDistributeResponse, err error) {
	response = CreateQueryResDistributeResponse()
	err = client.DoAction(request, response)
	return
}

// QueryResDistributeWithChan invokes the cloudcallcenter.QueryResDistribute API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryresdistribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryResDistributeWithChan(request *QueryResDistributeRequest) (<-chan *QueryResDistributeResponse, <-chan error) {
	responseChan := make(chan *QueryResDistributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryResDistribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryResDistributeWithCallback invokes the cloudcallcenter.QueryResDistribute API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryresdistribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryResDistributeWithCallback(request *QueryResDistributeRequest, callback func(response *QueryResDistributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryResDistributeResponse
		var err error
		defer close(result)
		response, err = client.QueryResDistribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryResDistributeRequest is the request struct for api QueryResDistribute
type QueryResDistributeRequest struct {
	*requests.RpcRequest
	SpecId requests.Integer `position:"Query" name:"SpecId"`
}

// QueryResDistributeResponse is the response struct for api QueryResDistribute
type QueryResDistributeResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateQueryResDistributeRequest creates a request to invoke QueryResDistribute API
func CreateQueryResDistributeRequest() (request *QueryResDistributeRequest) {
	request = &QueryResDistributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryResDistribute", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryResDistributeResponse creates a response to parse from QueryResDistribute response
func CreateQueryResDistributeResponse() (response *QueryResDistributeResponse) {
	response = &QueryResDistributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
