package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchStopGameSessions invokes the cloudgameapi.BatchStopGameSessions API synchronously
func (client *Client) BatchStopGameSessions(request *BatchStopGameSessionsRequest) (response *BatchStopGameSessionsResponse, err error) {
	response = CreateBatchStopGameSessionsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchStopGameSessionsWithChan invokes the cloudgameapi.BatchStopGameSessions API asynchronously
func (client *Client) BatchStopGameSessionsWithChan(request *BatchStopGameSessionsRequest) (<-chan *BatchStopGameSessionsResponse, <-chan error) {
	responseChan := make(chan *BatchStopGameSessionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchStopGameSessions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchStopGameSessionsWithCallback invokes the cloudgameapi.BatchStopGameSessions API asynchronously
func (client *Client) BatchStopGameSessionsWithCallback(request *BatchStopGameSessionsRequest, callback func(response *BatchStopGameSessionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchStopGameSessionsResponse
		var err error
		defer close(result)
		response, err = client.BatchStopGameSessions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchStopGameSessionsRequest is the request struct for api BatchStopGameSessions
type BatchStopGameSessionsRequest struct {
	*requests.RpcRequest
	GameId    string `position:"Query" name:"GameId"`
	Reason    string `position:"Query" name:"Reason"`
	ProjectId string `position:"Query" name:"ProjectId"`
	Token     string `position:"Query" name:"Token"`
	TrackInfo string `position:"Query" name:"TrackInfo"`
}

// BatchStopGameSessionsResponse is the response struct for api BatchStopGameSessions
type BatchStopGameSessionsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    bool   `json:"Success" xml:"Success"`
	QueueState int    `json:"QueueState" xml:"QueueState"`
	Message    string `json:"Message" xml:"Message"`
	GameId     string `json:"GameId" xml:"GameId"`
	ProjectId  string `json:"ProjectId" xml:"ProjectId"`
	TrackInfo  string `json:"TrackInfo" xml:"TrackInfo"`
}

// CreateBatchStopGameSessionsRequest creates a request to invoke BatchStopGameSessions API
func CreateBatchStopGameSessionsRequest() (request *BatchStopGameSessionsRequest) {
	request = &BatchStopGameSessionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "BatchStopGameSessions", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchStopGameSessionsResponse creates a response to parse from BatchStopGameSessions response
func CreateBatchStopGameSessionsResponse() (response *BatchStopGameSessionsResponse) {
	response = &BatchStopGameSessionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
