package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckCopyPayroll invokes the companyreg.CheckCopyPayroll API synchronously
func (client *Client) CheckCopyPayroll(request *CheckCopyPayrollRequest) (response *CheckCopyPayrollResponse, err error) {
	response = CreateCheckCopyPayrollResponse()
	err = client.DoAction(request, response)
	return
}

// CheckCopyPayrollWithChan invokes the companyreg.CheckCopyPayroll API asynchronously
func (client *Client) CheckCopyPayrollWithChan(request *CheckCopyPayrollRequest) (<-chan *CheckCopyPayrollResponse, <-chan error) {
	responseChan := make(chan *CheckCopyPayrollResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckCopyPayroll(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckCopyPayrollWithCallback invokes the companyreg.CheckCopyPayroll API asynchronously
func (client *Client) CheckCopyPayrollWithCallback(request *CheckCopyPayrollRequest, callback func(response *CheckCopyPayrollResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckCopyPayrollResponse
		var err error
		defer close(result)
		response, err = client.CheckCopyPayroll(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckCopyPayrollRequest is the request struct for api CheckCopyPayroll
type CheckCopyPayrollRequest struct {
	*requests.RpcRequest
	Period             string           `position:"Query" name:"Period"`
	UpdateEmployeeFlag requests.Boolean `position:"Query" name:"UpdateEmployeeFlag"`
	BizId              string           `position:"Query" name:"BizId"`
}

// CheckCopyPayrollResponse is the response struct for api CheckCopyPayroll
type CheckCopyPayrollResponse struct {
	*responses.BaseResponse
	IsExists  string `json:"IsExists" xml:"IsExists"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCheckCopyPayrollRequest creates a request to invoke CheckCopyPayroll API
func CreateCheckCopyPayrollRequest() (request *CheckCopyPayrollRequest) {
	request = &CheckCopyPayrollRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "CheckCopyPayroll", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckCopyPayrollResponse creates a response to parse from CheckCopyPayroll response
func CreateCheckCopyPayrollResponse() (response *CheckCopyPayrollResponse) {
	response = &CheckCopyPayrollResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
