package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseIcpProduce invokes the companyreg.CloseIcpProduce API synchronously
func (client *Client) CloseIcpProduce(request *CloseIcpProduceRequest) (response *CloseIcpProduceResponse, err error) {
	response = CreateCloseIcpProduceResponse()
	err = client.DoAction(request, response)
	return
}

// CloseIcpProduceWithChan invokes the companyreg.CloseIcpProduce API asynchronously
func (client *Client) CloseIcpProduceWithChan(request *CloseIcpProduceRequest) (<-chan *CloseIcpProduceResponse, <-chan error) {
	responseChan := make(chan *CloseIcpProduceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseIcpProduce(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseIcpProduceWithCallback invokes the companyreg.CloseIcpProduce API asynchronously
func (client *Client) CloseIcpProduceWithCallback(request *CloseIcpProduceRequest, callback func(response *CloseIcpProduceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseIcpProduceResponse
		var err error
		defer close(result)
		response, err = client.CloseIcpProduce(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseIcpProduceRequest is the request struct for api CloseIcpProduce
type CloseIcpProduceRequest struct {
	*requests.RpcRequest
	Note  string `position:"Query" name:"Note"`
	BizId string `position:"Query" name:"BizId"`
}

// CloseIcpProduceResponse is the response struct for api CloseIcpProduce
type CloseIcpProduceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateCloseIcpProduceRequest creates a request to invoke CloseIcpProduce API
func CreateCloseIcpProduceRequest() (request *CloseIcpProduceRequest) {
	request = &CloseIcpProduceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "CloseIcpProduce", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseIcpProduceResponse creates a response to parse from CloseIcpProduce response
func CreateCloseIcpProduceResponse() (response *CloseIcpProduceResponse) {
	response = &CloseIcpProduceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
