package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CopyPayroll invokes the companyreg.CopyPayroll API synchronously
func (client *Client) CopyPayroll(request *CopyPayrollRequest) (response *CopyPayrollResponse, err error) {
	response = CreateCopyPayrollResponse()
	err = client.DoAction(request, response)
	return
}

// CopyPayrollWithChan invokes the companyreg.CopyPayroll API asynchronously
func (client *Client) CopyPayrollWithChan(request *CopyPayrollRequest) (<-chan *CopyPayrollResponse, <-chan error) {
	responseChan := make(chan *CopyPayrollResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CopyPayroll(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CopyPayrollWithCallback invokes the companyreg.CopyPayroll API asynchronously
func (client *Client) CopyPayrollWithCallback(request *CopyPayrollRequest, callback func(response *CopyPayrollResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CopyPayrollResponse
		var err error
		defer close(result)
		response, err = client.CopyPayroll(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CopyPayrollRequest is the request struct for api CopyPayroll
type CopyPayrollRequest struct {
	*requests.RpcRequest
	Period string `position:"Query" name:"Period"`
	BizId  string `position:"Query" name:"BizId"`
}

// CopyPayrollResponse is the response struct for api CopyPayroll
type CopyPayrollResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCopyPayrollRequest creates a request to invoke CopyPayroll API
func CreateCopyPayrollRequest() (request *CopyPayrollRequest) {
	request = &CopyPayrollRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "CopyPayroll", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCopyPayrollResponse creates a response to parse from CopyPayroll response
func CreateCopyPayrollResponse() (response *CopyPayrollResponse) {
	response = &CopyPayrollResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
