package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCashFlowInfo invokes the companyreg.GetCashFlowInfo API synchronously
func (client *Client) GetCashFlowInfo(request *GetCashFlowInfoRequest) (response *GetCashFlowInfoResponse, err error) {
	response = CreateGetCashFlowInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetCashFlowInfoWithChan invokes the companyreg.GetCashFlowInfo API asynchronously
func (client *Client) GetCashFlowInfoWithChan(request *GetCashFlowInfoRequest) (<-chan *GetCashFlowInfoResponse, <-chan error) {
	responseChan := make(chan *GetCashFlowInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCashFlowInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCashFlowInfoWithCallback invokes the companyreg.GetCashFlowInfo API asynchronously
func (client *Client) GetCashFlowInfoWithCallback(request *GetCashFlowInfoRequest, callback func(response *GetCashFlowInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCashFlowInfoResponse
		var err error
		defer close(result)
		response, err = client.GetCashFlowInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCashFlowInfoRequest is the request struct for api GetCashFlowInfo
type GetCashFlowInfoRequest struct {
	*requests.RpcRequest
	Period string `position:"Query" name:"Period"`
	BizId  string `position:"Query" name:"BizId"`
}

// GetCashFlowInfoResponse is the response struct for api GetCashFlowInfo
type GetCashFlowInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Url       string `json:"Url" xml:"Url"`
}

// CreateGetCashFlowInfoRequest creates a request to invoke GetCashFlowInfo API
func CreateGetCashFlowInfoRequest() (request *GetCashFlowInfoRequest) {
	request = &GetCashFlowInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetCashFlowInfo", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetCashFlowInfoResponse creates a response to parse from GetCashFlowInfo response
func CreateGetCashFlowInfoResponse() (response *GetCashFlowInfoResponse) {
	response = &GetCashFlowInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
