package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPayrollSetting invokes the companyreg.GetPayrollSetting API synchronously
func (client *Client) GetPayrollSetting(request *GetPayrollSettingRequest) (response *GetPayrollSettingResponse, err error) {
	response = CreateGetPayrollSettingResponse()
	err = client.DoAction(request, response)
	return
}

// GetPayrollSettingWithChan invokes the companyreg.GetPayrollSetting API asynchronously
func (client *Client) GetPayrollSettingWithChan(request *GetPayrollSettingRequest) (<-chan *GetPayrollSettingResponse, <-chan error) {
	responseChan := make(chan *GetPayrollSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPayrollSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPayrollSettingWithCallback invokes the companyreg.GetPayrollSetting API asynchronously
func (client *Client) GetPayrollSettingWithCallback(request *GetPayrollSettingRequest, callback func(response *GetPayrollSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPayrollSettingResponse
		var err error
		defer close(result)
		response, err = client.GetPayrollSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPayrollSettingRequest is the request struct for api GetPayrollSetting
type GetPayrollSettingRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// GetPayrollSettingResponse is the response struct for api GetPayrollSetting
type GetPayrollSettingResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	PayrollAutoGrantRule string `json:"PayrollAutoGrantRule" xml:"PayrollAutoGrantRule"`
	PayrollGrantMode     string `json:"PayrollGrantMode" xml:"PayrollGrantMode"`
}

// CreateGetPayrollSettingRequest creates a request to invoke GetPayrollSetting API
func CreateGetPayrollSettingRequest() (request *GetPayrollSettingRequest) {
	request = &GetPayrollSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetPayrollSetting", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetPayrollSettingResponse creates a response to parse from GetPayrollSetting response
func CreateGetPayrollSettingResponse() (response *GetPayrollSettingResponse) {
	response = &GetPayrollSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
