package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeComplianceSummary invokes the config.DescribeComplianceSummary API synchronously
func (client *Client) DescribeComplianceSummary(request *DescribeComplianceSummaryRequest) (response *DescribeComplianceSummaryResponse, err error) {
	response = CreateDescribeComplianceSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeComplianceSummaryWithChan invokes the config.DescribeComplianceSummary API asynchronously
func (client *Client) DescribeComplianceSummaryWithChan(request *DescribeComplianceSummaryRequest) (<-chan *DescribeComplianceSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeComplianceSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeComplianceSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeComplianceSummaryWithCallback invokes the config.DescribeComplianceSummary API asynchronously
func (client *Client) DescribeComplianceSummaryWithCallback(request *DescribeComplianceSummaryRequest, callback func(response *DescribeComplianceSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeComplianceSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeComplianceSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeComplianceSummaryRequest is the request struct for api DescribeComplianceSummary
type DescribeComplianceSummaryRequest struct {
	*requests.RpcRequest
	MultiAccount requests.Boolean `position:"Query" name:"MultiAccount"`
	MemberId     requests.Integer `position:"Query" name:"MemberId"`
}

// DescribeComplianceSummaryResponse is the response struct for api DescribeComplianceSummary
type DescribeComplianceSummaryResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ComplianceSummary ComplianceSummary `json:"ComplianceSummary" xml:"ComplianceSummary"`
}

// CreateDescribeComplianceSummaryRequest creates a request to invoke DescribeComplianceSummary API
func CreateDescribeComplianceSummaryRequest() (request *DescribeComplianceSummaryRequest) {
	request = &DescribeComplianceSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2019-01-08", "DescribeComplianceSummary", "Config", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeComplianceSummaryResponse creates a response to parse from DescribeComplianceSummary response
func CreateDescribeComplianceSummaryResponse() (response *DescribeComplianceSummaryResponse) {
	response = &DescribeComplianceSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
