package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudBenchTasks invokes the das.DescribeCloudBenchTasks API synchronously
func (client *Client) DescribeCloudBenchTasks(request *DescribeCloudBenchTasksRequest) (response *DescribeCloudBenchTasksResponse, err error) {
	response = CreateDescribeCloudBenchTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudBenchTasksWithChan invokes the das.DescribeCloudBenchTasks API asynchronously
func (client *Client) DescribeCloudBenchTasksWithChan(request *DescribeCloudBenchTasksRequest) (<-chan *DescribeCloudBenchTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudBenchTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudBenchTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudBenchTasksWithCallback invokes the das.DescribeCloudBenchTasks API asynchronously
func (client *Client) DescribeCloudBenchTasksWithCallback(request *DescribeCloudBenchTasksRequest, callback func(response *DescribeCloudBenchTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudBenchTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudBenchTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudBenchTasksRequest is the request struct for api DescribeCloudBenchTasks
type DescribeCloudBenchTasksRequest struct {
	*requests.RpcRequest
	TaskType  string `position:"Query" name:"TaskType"`
	EndTime   string `position:"Query" name:"EndTime"`
	StartTime string `position:"Query" name:"StartTime"`
	PageNo    string `position:"Query" name:"PageNo"`
	PageSize  string `position:"Query" name:"PageSize"`
	Status    string `position:"Query" name:"Status"`
}

// DescribeCloudBenchTasksResponse is the response struct for api DescribeCloudBenchTasks
type DescribeCloudBenchTasksResponse struct {
	*responses.BaseResponse
	Code      string                        `json:"Code" xml:"Code"`
	Message   string                        `json:"Message" xml:"Message"`
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	Success   string                        `json:"Success" xml:"Success"`
	Data      DataInDescribeCloudBenchTasks `json:"Data" xml:"Data"`
}

// CreateDescribeCloudBenchTasksRequest creates a request to invoke DescribeCloudBenchTasks API
func CreateDescribeCloudBenchTasksRequest() (request *DescribeCloudBenchTasksRequest) {
	request = &DescribeCloudBenchTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DescribeCloudBenchTasks", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudBenchTasksResponse creates a response to parse from DescribeCloudBenchTasks response
func CreateDescribeCloudBenchTasksResponse() (response *DescribeCloudBenchTasksResponse) {
	response = &DescribeCloudBenchTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
