package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosticReportList invokes the das.DescribeDiagnosticReportList API synchronously
func (client *Client) DescribeDiagnosticReportList(request *DescribeDiagnosticReportListRequest) (response *DescribeDiagnosticReportListResponse, err error) {
	response = CreateDescribeDiagnosticReportListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosticReportListWithChan invokes the das.DescribeDiagnosticReportList API asynchronously
func (client *Client) DescribeDiagnosticReportListWithChan(request *DescribeDiagnosticReportListRequest) (<-chan *DescribeDiagnosticReportListResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosticReportListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosticReportList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosticReportListWithCallback invokes the das.DescribeDiagnosticReportList API asynchronously
func (client *Client) DescribeDiagnosticReportListWithCallback(request *DescribeDiagnosticReportListRequest, callback func(response *DescribeDiagnosticReportListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosticReportListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosticReportList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosticReportListRequest is the request struct for api DescribeDiagnosticReportList
type DescribeDiagnosticReportListRequest struct {
	*requests.RpcRequest
	SkipAuth     string `position:"Query" name:"skipAuth"`
	Signature    string `position:"Query" name:"signature"`
	StartTime    string `position:"Query" name:"StartTime"`
	UserId       string `position:"Query" name:"UserId"`
	Uid          string `position:"Query" name:"Uid"`
	AccessKey    string `position:"Query" name:"accessKey"`
	PageSize     string `position:"Query" name:"PageSize"`
	DBInstanceId string `position:"Query" name:"DBInstanceId"`
	Timestamp    string `position:"Query" name:"timestamp"`
	Context      string `position:"Query" name:"__context"`
	EndTime      string `position:"Query" name:"EndTime"`
	PageNo       string `position:"Query" name:"PageNo"`
}

// DescribeDiagnosticReportListResponse is the response struct for api DescribeDiagnosticReportList
type DescribeDiagnosticReportListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDescribeDiagnosticReportListRequest creates a request to invoke DescribeDiagnosticReportList API
func CreateDescribeDiagnosticReportListRequest() (request *DescribeDiagnosticReportListRequest) {
	request = &DescribeDiagnosticReportListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DescribeDiagnosticReportList", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiagnosticReportListResponse creates a response to parse from DescribeDiagnosticReportList response
func CreateDescribeDiagnosticReportListResponse() (response *DescribeDiagnosticReportListResponse) {
	response = &DescribeDiagnosticReportListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
