package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunCloudBenchTask invokes the das.RunCloudBenchTask API synchronously
func (client *Client) RunCloudBenchTask(request *RunCloudBenchTaskRequest) (response *RunCloudBenchTaskResponse, err error) {
	response = CreateRunCloudBenchTaskResponse()
	err = client.DoAction(request, response)
	return
}

// RunCloudBenchTaskWithChan invokes the das.RunCloudBenchTask API asynchronously
func (client *Client) RunCloudBenchTaskWithChan(request *RunCloudBenchTaskRequest) (<-chan *RunCloudBenchTaskResponse, <-chan error) {
	responseChan := make(chan *RunCloudBenchTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunCloudBenchTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunCloudBenchTaskWithCallback invokes the das.RunCloudBenchTask API asynchronously
func (client *Client) RunCloudBenchTaskWithCallback(request *RunCloudBenchTaskRequest, callback func(response *RunCloudBenchTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunCloudBenchTaskResponse
		var err error
		defer close(result)
		response, err = client.RunCloudBenchTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunCloudBenchTaskRequest is the request struct for api RunCloudBenchTask
type RunCloudBenchTaskRequest struct {
	*requests.RpcRequest
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	TaskId         string `position:"Query" name:"TaskId"`
}

// RunCloudBenchTaskResponse is the response struct for api RunCloudBenchTask
type RunCloudBenchTaskResponse struct {
	*responses.BaseResponse
	Code      string                  `json:"Code" xml:"Code"`
	Message   string                  `json:"Message" xml:"Message"`
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Success   string                  `json:"Success" xml:"Success"`
	Data      DataInRunCloudBenchTask `json:"Data" xml:"Data"`
}

// CreateRunCloudBenchTaskRequest creates a request to invoke RunCloudBenchTask API
func CreateRunCloudBenchTaskRequest() (request *RunCloudBenchTaskRequest) {
	request = &RunCloudBenchTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "RunCloudBenchTask", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRunCloudBenchTaskResponse creates a response to parse from RunCloudBenchTask response
func CreateRunCloudBenchTaskResponse() (response *RunCloudBenchTaskResponse) {
	response = &RunCloudBenchTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
