package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePermissionApplyOrder invokes the dataworks_public.CreatePermissionApplyOrder API synchronously
func (client *Client) CreatePermissionApplyOrder(request *CreatePermissionApplyOrderRequest) (response *CreatePermissionApplyOrderResponse, err error) {
	response = CreateCreatePermissionApplyOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePermissionApplyOrderWithChan invokes the dataworks_public.CreatePermissionApplyOrder API asynchronously
func (client *Client) CreatePermissionApplyOrderWithChan(request *CreatePermissionApplyOrderRequest) (<-chan *CreatePermissionApplyOrderResponse, <-chan error) {
	responseChan := make(chan *CreatePermissionApplyOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePermissionApplyOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePermissionApplyOrderWithCallback invokes the dataworks_public.CreatePermissionApplyOrder API asynchronously
func (client *Client) CreatePermissionApplyOrderWithCallback(request *CreatePermissionApplyOrderRequest, callback func(response *CreatePermissionApplyOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePermissionApplyOrderResponse
		var err error
		defer close(result)
		response, err = client.CreatePermissionApplyOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePermissionApplyOrderRequest is the request struct for api CreatePermissionApplyOrder
type CreatePermissionApplyOrderRequest struct {
	*requests.RpcRequest
	ApplyReason           string                                   `position:"Query" name:"ApplyReason"`
	MaxComputeProjectName string                                   `position:"Query" name:"MaxComputeProjectName"`
	ApplyObject           *[]CreatePermissionApplyOrderApplyObject `position:"Query" name:"ApplyObject"  type:"Repeated"`
	ApplyUserIds          string                                   `position:"Query" name:"ApplyUserIds"`
	Deadline              requests.Integer                         `position:"Query" name:"Deadline"`
	WorkspaceId           requests.Integer                         `position:"Query" name:"WorkspaceId"`
	OrderType             requests.Integer                         `position:"Query" name:"OrderType"`
	EngineType            string                                   `position:"Query" name:"EngineType"`
}

// CreatePermissionApplyOrderApplyObject is a repeated param struct in CreatePermissionApplyOrderRequest
type CreatePermissionApplyOrderApplyObject struct {
	ColumnMetaList *[]CreatePermissionApplyOrderColumnMetaList `name:"ColumnMetaList" type:"Repeated"`
	Name           string                                      `name:"Name"`
	Actions        string                                      `name:"Actions"`
}

// CreatePermissionApplyOrderColumnMetaList is a repeated param struct in CreatePermissionApplyOrderRequest
type CreatePermissionApplyOrderColumnMetaList struct {
	Name string `name:"Name"`
}

// CreatePermissionApplyOrderResponse is the response struct for api CreatePermissionApplyOrder
type CreatePermissionApplyOrderResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	FlowId    []string `json:"FlowId" xml:"FlowId"`
}

// CreateCreatePermissionApplyOrderRequest creates a request to invoke CreatePermissionApplyOrder API
func CreateCreatePermissionApplyOrderRequest() (request *CreatePermissionApplyOrderRequest) {
	request = &CreatePermissionApplyOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreatePermissionApplyOrder", "", "")
	request.Method = requests.POST
	return
}

// CreateCreatePermissionApplyOrderResponse creates a response to parse from CreatePermissionApplyOrder response
func CreateCreatePermissionApplyOrderResponse() (response *CreatePermissionApplyOrderResponse) {
	response = &CreatePermissionApplyOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
