package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeParents invokes the dataworks_public.GetNodeParents API synchronously
func (client *Client) GetNodeParents(request *GetNodeParentsRequest) (response *GetNodeParentsResponse, err error) {
	response = CreateGetNodeParentsResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeParentsWithChan invokes the dataworks_public.GetNodeParents API asynchronously
func (client *Client) GetNodeParentsWithChan(request *GetNodeParentsRequest) (<-chan *GetNodeParentsResponse, <-chan error) {
	responseChan := make(chan *GetNodeParentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeParents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeParentsWithCallback invokes the dataworks_public.GetNodeParents API asynchronously
func (client *Client) GetNodeParentsWithCallback(request *GetNodeParentsRequest, callback func(response *GetNodeParentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeParentsResponse
		var err error
		defer close(result)
		response, err = client.GetNodeParents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeParentsRequest is the request struct for api GetNodeParents
type GetNodeParentsRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	NodeId     requests.Integer `position:"Body" name:"NodeId"`
}

// GetNodeParentsResponse is the response struct for api GetNodeParents
type GetNodeParentsResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetNodeParentsRequest creates a request to invoke GetNodeParents API
func CreateGetNodeParentsRequest() (request *GetNodeParentsRequest) {
	request = &GetNodeParentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetNodeParents", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNodeParentsResponse creates a response to parse from GetNodeParents response
func CreateGetNodeParentsResponse() (response *GetNodeParentsResponse) {
	response = &GetNodeParentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
