package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCalcEngines invokes the dataworks_public.ListCalcEngines API synchronously
func (client *Client) ListCalcEngines(request *ListCalcEnginesRequest) (response *ListCalcEnginesResponse, err error) {
	response = CreateListCalcEnginesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCalcEnginesWithChan invokes the dataworks_public.ListCalcEngines API asynchronously
func (client *Client) ListCalcEnginesWithChan(request *ListCalcEnginesRequest) (<-chan *ListCalcEnginesResponse, <-chan error) {
	responseChan := make(chan *ListCalcEnginesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCalcEngines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCalcEnginesWithCallback invokes the dataworks_public.ListCalcEngines API asynchronously
func (client *Client) ListCalcEnginesWithCallback(request *ListCalcEnginesRequest, callback func(response *ListCalcEnginesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCalcEnginesResponse
		var err error
		defer close(result)
		response, err = client.ListCalcEngines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCalcEnginesRequest is the request struct for api ListCalcEngines
type ListCalcEnginesRequest struct {
	*requests.RpcRequest
	CalcEngineType string           `position:"Query" name:"CalcEngineType"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	Name           string           `position:"Query" name:"Name"`
	EnvType        string           `position:"Query" name:"EnvType"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
}

// ListCalcEnginesResponse is the response struct for api ListCalcEngines
type ListCalcEnginesResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                   `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool                  `json:"Success" xml:"Success"`
	RequestId      string                `json:"RequestId" xml:"RequestId"`
	Data           DataInListCalcEngines `json:"Data" xml:"Data"`
}

// CreateListCalcEnginesRequest creates a request to invoke ListCalcEngines API
func CreateListCalcEnginesRequest() (request *ListCalcEnginesRequest) {
	request = &ListCalcEnginesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListCalcEngines", "", "")
	request.Method = requests.POST
	return
}

// CreateListCalcEnginesResponse creates a response to parse from ListCalcEngines response
func CreateListCalcEnginesResponse() (response *ListCalcEnginesResponse) {
	response = &ListCalcEnginesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
