package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAutoCcListCount invokes the ddoscoo.DescribeAutoCcListCount API synchronously
func (client *Client) DescribeAutoCcListCount(request *DescribeAutoCcListCountRequest) (response *DescribeAutoCcListCountResponse, err error) {
	response = CreateDescribeAutoCcListCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAutoCcListCountWithChan invokes the ddoscoo.DescribeAutoCcListCount API asynchronously
func (client *Client) DescribeAutoCcListCountWithChan(request *DescribeAutoCcListCountRequest) (<-chan *DescribeAutoCcListCountResponse, <-chan error) {
	responseChan := make(chan *DescribeAutoCcListCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAutoCcListCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAutoCcListCountWithCallback invokes the ddoscoo.DescribeAutoCcListCount API asynchronously
func (client *Client) DescribeAutoCcListCountWithCallback(request *DescribeAutoCcListCountRequest, callback func(response *DescribeAutoCcListCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAutoCcListCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeAutoCcListCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAutoCcListCountRequest is the request struct for api DescribeAutoCcListCount
type DescribeAutoCcListCountRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	QueryType  string `position:"Query" name:"QueryType"`
}

// DescribeAutoCcListCountResponse is the response struct for api DescribeAutoCcListCount
type DescribeAutoCcListCountResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	WhiteCount int    `json:"WhiteCount" xml:"WhiteCount"`
	BlackCount int    `json:"BlackCount" xml:"BlackCount"`
}

// CreateDescribeAutoCcListCountRequest creates a request to invoke DescribeAutoCcListCount API
func CreateDescribeAutoCcListCountRequest() (request *DescribeAutoCcListCountRequest) {
	request = &DescribeAutoCcListCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeAutoCcListCount", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAutoCcListCountResponse creates a response to parse from DescribeAutoCcListCount response
func CreateDescribeAutoCcListCountResponse() (response *DescribeAutoCcListCountResponse) {
	response = &DescribeAutoCcListCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
