package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJobMonitorRule invokes the dts.DescribeJobMonitorRule API synchronously
func (client *Client) DescribeJobMonitorRule(request *DescribeJobMonitorRuleRequest) (response *DescribeJobMonitorRuleResponse, err error) {
	response = CreateDescribeJobMonitorRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJobMonitorRuleWithChan invokes the dts.DescribeJobMonitorRule API asynchronously
func (client *Client) DescribeJobMonitorRuleWithChan(request *DescribeJobMonitorRuleRequest) (<-chan *DescribeJobMonitorRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeJobMonitorRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJobMonitorRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJobMonitorRuleWithCallback invokes the dts.DescribeJobMonitorRule API asynchronously
func (client *Client) DescribeJobMonitorRuleWithCallback(request *DescribeJobMonitorRuleRequest, callback func(response *DescribeJobMonitorRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJobMonitorRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeJobMonitorRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJobMonitorRuleRequest is the request struct for api DescribeJobMonitorRule
type DescribeJobMonitorRuleRequest struct {
	*requests.RpcRequest
	DtsJobId string `position:"Query" name:"DtsJobId"`
}

// DescribeJobMonitorRuleResponse is the response struct for api DescribeJobMonitorRule
type DescribeJobMonitorRuleResponse struct {
	*responses.BaseResponse
	Code           string        `json:"Code" xml:"Code"`
	DtsJobId       string        `json:"DtsJobId" xml:"DtsJobId"`
	DynamicMessage string        `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrCode        string        `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string        `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode int           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string        `json:"RequestId" xml:"RequestId"`
	Success        bool          `json:"Success" xml:"Success"`
	MonitorRules   []MonitorRule `json:"MonitorRules" xml:"MonitorRules"`
}

// CreateDescribeJobMonitorRuleRequest creates a request to invoke DescribeJobMonitorRule API
func CreateDescribeJobMonitorRuleRequest() (request *DescribeJobMonitorRuleRequest) {
	request = &DescribeJobMonitorRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeJobMonitorRule", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeJobMonitorRuleResponse creates a response to parse from DescribeJobMonitorRule response
func CreateDescribeJobMonitorRuleResponse() (response *DescribeJobMonitorRuleResponse) {
	response = &DescribeJobMonitorRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
