package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// WhiteIpList invokes the dts.WhiteIpList API synchronously
func (client *Client) WhiteIpList(request *WhiteIpListRequest) (response *WhiteIpListResponse, err error) {
	response = CreateWhiteIpListResponse()
	err = client.DoAction(request, response)
	return
}

// WhiteIpListWithChan invokes the dts.WhiteIpList API asynchronously
func (client *Client) WhiteIpListWithChan(request *WhiteIpListRequest) (<-chan *WhiteIpListResponse, <-chan error) {
	responseChan := make(chan *WhiteIpListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.WhiteIpList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// WhiteIpListWithCallback invokes the dts.WhiteIpList API asynchronously
func (client *Client) WhiteIpListWithCallback(request *WhiteIpListRequest, callback func(response *WhiteIpListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *WhiteIpListResponse
		var err error
		defer close(result)
		response, err = client.WhiteIpList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// WhiteIpListRequest is the request struct for api WhiteIpList
type WhiteIpListRequest struct {
	*requests.RpcRequest
	DestinationRegion string `position:"Query" name:"DestinationRegion"`
	Type              string `position:"Query" name:"Type"`
	Region            string `position:"Query" name:"Region"`
}

// WhiteIpListResponse is the response struct for api WhiteIpList
type WhiteIpListResponse struct {
	*responses.BaseResponse
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	IpList         string `json:"IpList" xml:"IpList"`
}

// CreateWhiteIpListRequest creates a request to invoke WhiteIpList API
func CreateWhiteIpListRequest() (request *WhiteIpListRequest) {
	request = &WhiteIpListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "WhiteIpList", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateWhiteIpListResponse creates a response to parse from WhiteIpList response
func CreateWhiteIpListResponse() (response *WhiteIpListResponse) {
	response = &WhiteIpListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
