package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAvailableRegions invokes the eas.GetAvailableRegions API synchronously
// api document: https://help.aliyun.com/api/eas/getavailableregions.html
func (client *Client) GetAvailableRegions(request *GetAvailableRegionsRequest) (response *GetAvailableRegionsResponse, err error) {
	response = CreateGetAvailableRegionsResponse()
	err = client.DoAction(request, response)
	return
}

// GetAvailableRegionsWithChan invokes the eas.GetAvailableRegions API asynchronously
// api document: https://help.aliyun.com/api/eas/getavailableregions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAvailableRegionsWithChan(request *GetAvailableRegionsRequest) (<-chan *GetAvailableRegionsResponse, <-chan error) {
	responseChan := make(chan *GetAvailableRegionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAvailableRegions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAvailableRegionsWithCallback invokes the eas.GetAvailableRegions API asynchronously
// api document: https://help.aliyun.com/api/eas/getavailableregions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAvailableRegionsWithCallback(request *GetAvailableRegionsRequest, callback func(response *GetAvailableRegionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAvailableRegionsResponse
		var err error
		defer close(result)
		response, err = client.GetAvailableRegions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAvailableRegionsRequest is the request struct for api GetAvailableRegions
type GetAvailableRegionsRequest struct {
	*requests.RoaRequest
}

// GetAvailableRegionsResponse is the response struct for api GetAvailableRegions
type GetAvailableRegionsResponse struct {
	*responses.BaseResponse
}

// CreateGetAvailableRegionsRequest creates a request to invoke GetAvailableRegions API
func CreateGetAvailableRegionsRequest() (request *GetAvailableRegionsRequest) {
	request = &GetAvailableRegionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "GetAvailableRegions", "/api/services/regions", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAvailableRegionsResponse creates a response to parse from GetAvailableRegions response
func CreateGetAvailableRegionsResponse() (response *GetAvailableRegionsResponse) {
	response = &GetAvailableRegionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
