package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClusterV2 invokes the emr.CreateClusterV2 API synchronously
func (client *Client) CreateClusterV2(request *CreateClusterV2Request) (response *CreateClusterV2Response, err error) {
	response = CreateCreateClusterV2Response()
	err = client.DoAction(request, response)
	return
}

// CreateClusterV2WithChan invokes the emr.CreateClusterV2 API asynchronously
func (client *Client) CreateClusterV2WithChan(request *CreateClusterV2Request) (<-chan *CreateClusterV2Response, <-chan error) {
	responseChan := make(chan *CreateClusterV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClusterV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterV2WithCallback invokes the emr.CreateClusterV2 API asynchronously
func (client *Client) CreateClusterV2WithCallback(request *CreateClusterV2Request, callback func(response *CreateClusterV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterV2Response
		var err error
		defer close(result)
		response, err = client.CreateClusterV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterV2Request is the request struct for api CreateClusterV2
type CreateClusterV2Request struct {
	*requests.RpcRequest
	AutoPayOrder           requests.Boolean                    `position:"Query" name:"AutoPayOrder"`
	ResourceOwnerId        requests.Integer                    `position:"Query" name:"ResourceOwnerId"`
	LogPath                string                              `position:"Query" name:"LogPath"`
	MasterPwd              string                              `position:"Query" name:"MasterPwd"`
	Configurations         string                              `position:"Query" name:"Configurations"`
	SshEnable              requests.Boolean                    `position:"Query" name:"SshEnable"`
	KeyPairName            string                              `position:"Query" name:"KeyPairName"`
	MetaStoreType          string                              `position:"Query" name:"MetaStoreType"`
	SecurityGroupName      string                              `position:"Query" name:"SecurityGroupName"`
	MachineType            string                              `position:"Query" name:"MachineType"`
	ResourceGroupId        string                              `position:"Query" name:"ResourceGroupId"`
	HostComponentInfo      *[]CreateClusterV2HostComponentInfo `position:"Query" name:"HostComponentInfo"  type:"Repeated"`
	ClickHouseConf         string                              `position:"Query" name:"ClickHouseConf"`
	BootstrapAction        *[]CreateClusterV2BootstrapAction   `position:"Query" name:"BootstrapAction"  type:"Repeated"`
	MetaStoreConf          string                              `position:"Query" name:"MetaStoreConf"`
	EmrVer                 string                              `position:"Query" name:"EmrVer"`
	Tag                    *[]CreateClusterV2Tag               `position:"Query" name:"Tag"  type:"Repeated"`
	AuthorizeContent       string                              `position:"Query" name:"AuthorizeContent"`
	IsOpenPublicIp         requests.Boolean                    `position:"Query" name:"IsOpenPublicIp"`
	Period                 requests.Integer                    `position:"Query" name:"Period"`
	InstanceGeneration     string                              `position:"Query" name:"InstanceGeneration"`
	VSwitchId              string                              `position:"Query" name:"VSwitchId"`
	ClusterType            string                              `position:"Query" name:"ClusterType"`
	ExtraAttributes        string                              `position:"Query" name:"ExtraAttributes"`
	AutoRenew              requests.Boolean                    `position:"Query" name:"AutoRenew"`
	OptionSoftWareList     *[]string                           `position:"Query" name:"OptionSoftWareList"  type:"Repeated"`
	NetType                string                              `position:"Query" name:"NetType"`
	Name                   string                              `position:"Query" name:"Name"`
	ZoneId                 string                              `position:"Query" name:"ZoneId"`
	UseCustomHiveMetaDB    requests.Boolean                    `position:"Query" name:"UseCustomHiveMetaDB"`
	InitCustomHiveMetaDB   requests.Boolean                    `position:"Query" name:"InitCustomHiveMetaDB"`
	IoOptimized            requests.Boolean                    `position:"Query" name:"IoOptimized"`
	SecurityGroupId        string                              `position:"Query" name:"SecurityGroupId"`
	EasEnable              requests.Boolean                    `position:"Query" name:"EasEnable"`
	DepositType            string                              `position:"Query" name:"DepositType"`
	UseLocalMetaDb         requests.Boolean                    `position:"Query" name:"UseLocalMetaDb"`
	UserInfo               *[]CreateClusterV2UserInfo          `position:"Query" name:"UserInfo"  type:"Repeated"`
	UserDefinedEmrEcsRole  string                              `position:"Query" name:"UserDefinedEmrEcsRole"`
	WhiteListType          string                              `position:"Query" name:"WhiteListType"`
	RelatedClusterId       string                              `position:"Query" name:"RelatedClusterId"`
	VpcId                  string                              `position:"Query" name:"VpcId"`
	PromotionInfo          *[]CreateClusterV2PromotionInfo     `position:"Query" name:"PromotionInfo"  type:"Repeated"`
	HostGroup              *[]CreateClusterV2HostGroup         `position:"Query" name:"HostGroup"  type:"Repeated"`
	ChargeType             string                              `position:"Query" name:"ChargeType"`
	ServiceInfo            *[]CreateClusterV2ServiceInfo       `position:"Query" name:"ServiceInfo"  type:"Repeated"`
	Config                 *[]CreateClusterV2Config            `position:"Query" name:"Config"  type:"Repeated"`
	HighAvailabilityEnable requests.Boolean                    `position:"Query" name:"HighAvailabilityEnable"`
}

// CreateClusterV2HostComponentInfo is a repeated param struct in CreateClusterV2Request
type CreateClusterV2HostComponentInfo struct {
	HostName          string    `name:"HostName"`
	ComponentNameList *[]string `name:"ComponentNameList" type:"Repeated"`
	ServiceName       string    `name:"ServiceName"`
}

// CreateClusterV2BootstrapAction is a repeated param struct in CreateClusterV2Request
type CreateClusterV2BootstrapAction struct {
	Path                  string `name:"Path"`
	ExecutionTarget       string `name:"ExecutionTarget"`
	ExecutionMoment       string `name:"ExecutionMoment"`
	Arg                   string `name:"Arg"`
	Name                  string `name:"Name"`
	ExecutionFailStrategy string `name:"ExecutionFailStrategy"`
}

// CreateClusterV2Tag is a repeated param struct in CreateClusterV2Request
type CreateClusterV2Tag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateClusterV2UserInfo is a repeated param struct in CreateClusterV2Request
type CreateClusterV2UserInfo struct {
	Password string `name:"Password"`
	UserId   string `name:"UserId"`
	UserName string `name:"UserName"`
}

// CreateClusterV2PromotionInfo is a repeated param struct in CreateClusterV2Request
type CreateClusterV2PromotionInfo struct {
	PromotionOptionCode string `name:"PromotionOptionCode"`
	ProductCode         string `name:"ProductCode"`
	PromotionOptionNo   string `name:"PromotionOptionNo"`
}

// CreateClusterV2HostGroup is a repeated param struct in CreateClusterV2Request
type CreateClusterV2HostGroup struct {
	Period          string `name:"Period"`
	SysDiskCapacity string `name:"SysDiskCapacity"`
	DiskCapacity    string `name:"DiskCapacity"`
	SysDiskType     string `name:"SysDiskType"`
	ClusterId       string `name:"ClusterId"`
	DiskType        string `name:"DiskType"`
	HostGroupName   string `name:"HostGroupName"`
	VSwitchId       string `name:"VSwitchId"`
	DiskCount       string `name:"DiskCount"`
	AutoRenew       string `name:"AutoRenew"`
	GpuDriver       string `name:"GpuDriver"`
	HostGroupId     string `name:"HostGroupId"`
	NodeCount       string `name:"NodeCount"`
	InstanceType    string `name:"InstanceType"`
	Comment         string `name:"Comment"`
	ChargeType      string `name:"ChargeType"`
	CreateType      string `name:"CreateType"`
	HostGroupType   string `name:"HostGroupType"`
}

// CreateClusterV2ServiceInfo is a repeated param struct in CreateClusterV2Request
type CreateClusterV2ServiceInfo struct {
	ServiceVersion string `name:"ServiceVersion"`
	ServiceName    string `name:"ServiceName"`
}

// CreateClusterV2Config is a repeated param struct in CreateClusterV2Request
type CreateClusterV2Config struct {
	ConfigKey   string `name:"ConfigKey"`
	FileName    string `name:"FileName"`
	Encrypt     string `name:"Encrypt"`
	Replace     string `name:"Replace"`
	ConfigValue string `name:"ConfigValue"`
	ServiceName string `name:"ServiceName"`
}

// CreateClusterV2Response is the response struct for api CreateClusterV2
type CreateClusterV2Response struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ClusterId     string `json:"ClusterId" xml:"ClusterId"`
	EmrOrderId    string `json:"EmrOrderId" xml:"EmrOrderId"`
	MasterOrderId string `json:"MasterOrderId" xml:"MasterOrderId"`
	CoreOrderId   string `json:"CoreOrderId" xml:"CoreOrderId"`
}

// CreateCreateClusterV2Request creates a request to invoke CreateClusterV2 API
func CreateCreateClusterV2Request() (request *CreateClusterV2Request) {
	request = &CreateClusterV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateClusterV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateClusterV2Response creates a response to parse from CreateClusterV2 response
func CreateCreateClusterV2Response() (response *CreateClusterV2Response) {
	response = &CreateClusterV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
