package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddNetworkInterfaceToInstance invokes the ens.AddNetworkInterfaceToInstance API synchronously
func (client *Client) AddNetworkInterfaceToInstance(request *AddNetworkInterfaceToInstanceRequest) (response *AddNetworkInterfaceToInstanceResponse, err error) {
	response = CreateAddNetworkInterfaceToInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// AddNetworkInterfaceToInstanceWithChan invokes the ens.AddNetworkInterfaceToInstance API asynchronously
func (client *Client) AddNetworkInterfaceToInstanceWithChan(request *AddNetworkInterfaceToInstanceRequest) (<-chan *AddNetworkInterfaceToInstanceResponse, <-chan error) {
	responseChan := make(chan *AddNetworkInterfaceToInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddNetworkInterfaceToInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddNetworkInterfaceToInstanceWithCallback invokes the ens.AddNetworkInterfaceToInstance API asynchronously
func (client *Client) AddNetworkInterfaceToInstanceWithCallback(request *AddNetworkInterfaceToInstanceRequest, callback func(response *AddNetworkInterfaceToInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddNetworkInterfaceToInstanceResponse
		var err error
		defer close(result)
		response, err = client.AddNetworkInterfaceToInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddNetworkInterfaceToInstanceRequest is the request struct for api AddNetworkInterfaceToInstance
type AddNetworkInterfaceToInstanceRequest struct {
	*requests.RpcRequest
	Networks   string `position:"Query" name:"Networks"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// AddNetworkInterfaceToInstanceResponse is the response struct for api AddNetworkInterfaceToInstance
type AddNetworkInterfaceToInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddNetworkInterfaceToInstanceRequest creates a request to invoke AddNetworkInterfaceToInstance API
func CreateAddNetworkInterfaceToInstanceRequest() (request *AddNetworkInterfaceToInstanceRequest) {
	request = &AddNetworkInterfaceToInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "AddNetworkInterfaceToInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddNetworkInterfaceToInstanceResponse creates a response to parse from AddNetworkInterfaceToInstance response
func CreateAddNetworkInterfaceToInstanceResponse() (response *AddNetworkInterfaceToInstanceResponse) {
	response = &AddNetworkInterfaceToInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
