package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindQueue invokes the foas.BindQueue API synchronously
// api document: https://help.aliyun.com/api/foas/bindqueue.html
func (client *Client) BindQueue(request *BindQueueRequest) (response *BindQueueResponse, err error) {
	response = CreateBindQueueResponse()
	err = client.DoAction(request, response)
	return
}

// BindQueueWithChan invokes the foas.BindQueue API asynchronously
// api document: https://help.aliyun.com/api/foas/bindqueue.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindQueueWithChan(request *BindQueueRequest) (<-chan *BindQueueResponse, <-chan error) {
	responseChan := make(chan *BindQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindQueueWithCallback invokes the foas.BindQueue API asynchronously
// api document: https://help.aliyun.com/api/foas/bindqueue.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindQueueWithCallback(request *BindQueueRequest, callback func(response *BindQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindQueueResponse
		var err error
		defer close(result)
		response, err = client.BindQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindQueueRequest is the request struct for api BindQueue
type BindQueueRequest struct {
	*requests.RoaRequest
	QueueName   string `position:"Body" name:"queueName"`
	ProjectName string `position:"Path" name:"projectName"`
	ClusterId   string `position:"Body" name:"clusterId"`
}

// BindQueueResponse is the response struct for api BindQueue
type BindQueueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindQueueRequest creates a request to invoke BindQueue API
func CreateBindQueueRequest() (request *BindQueueRequest) {
	request = &BindQueueRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "BindQueue", "/api/v2/projects/[projectName]/queue", "foas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindQueueResponse creates a response to parse from BindQueue response
func CreateBindQueueResponse() (response *BindQueueResponse) {
	response = &BindQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
