package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobLatestAutoScalePlan invokes the foas.GetJobLatestAutoScalePlan API synchronously
// api document: https://help.aliyun.com/api/foas/getjoblatestautoscaleplan.html
func (client *Client) GetJobLatestAutoScalePlan(request *GetJobLatestAutoScalePlanRequest) (response *GetJobLatestAutoScalePlanResponse, err error) {
	response = CreateGetJobLatestAutoScalePlanResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobLatestAutoScalePlanWithChan invokes the foas.GetJobLatestAutoScalePlan API asynchronously
// api document: https://help.aliyun.com/api/foas/getjoblatestautoscaleplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobLatestAutoScalePlanWithChan(request *GetJobLatestAutoScalePlanRequest) (<-chan *GetJobLatestAutoScalePlanResponse, <-chan error) {
	responseChan := make(chan *GetJobLatestAutoScalePlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobLatestAutoScalePlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobLatestAutoScalePlanWithCallback invokes the foas.GetJobLatestAutoScalePlan API asynchronously
// api document: https://help.aliyun.com/api/foas/getjoblatestautoscaleplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobLatestAutoScalePlanWithCallback(request *GetJobLatestAutoScalePlanRequest, callback func(response *GetJobLatestAutoScalePlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobLatestAutoScalePlanResponse
		var err error
		defer close(result)
		response, err = client.GetJobLatestAutoScalePlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobLatestAutoScalePlanRequest is the request struct for api GetJobLatestAutoScalePlan
type GetJobLatestAutoScalePlanRequest struct {
	*requests.RoaRequest
	ProjectName string `position:"Path" name:"projectName"`
	JobName     string `position:"Path" name:"jobName"`
}

// GetJobLatestAutoScalePlanResponse is the response struct for api GetJobLatestAutoScalePlan
type GetJobLatestAutoScalePlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	PlanJson  string `json:"PlanJson" xml:"PlanJson"`
}

// CreateGetJobLatestAutoScalePlanRequest creates a request to invoke GetJobLatestAutoScalePlan API
func CreateGetJobLatestAutoScalePlanRequest() (request *GetJobLatestAutoScalePlanRequest) {
	request = &GetJobLatestAutoScalePlanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetJobLatestAutoScalePlan", "/api/v2/projects/[projectName]/jobs/[jobName]/autoscale/latestplanjson", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetJobLatestAutoScalePlanResponse creates a response to parse from GetJobLatestAutoScalePlan response
func CreateGetJobLatestAutoScalePlanResponse() (response *GetJobLatestAutoScalePlanResponse) {
	response = &GetJobLatestAutoScalePlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
