package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImageLib invokes the green.DescribeImageLib API synchronously
func (client *Client) DescribeImageLib(request *DescribeImageLibRequest) (response *DescribeImageLibResponse, err error) {
	response = CreateDescribeImageLibResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageLibWithChan invokes the green.DescribeImageLib API asynchronously
func (client *Client) DescribeImageLibWithChan(request *DescribeImageLibRequest) (<-chan *DescribeImageLibResponse, <-chan error) {
	responseChan := make(chan *DescribeImageLibResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImageLib(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageLibWithCallback invokes the green.DescribeImageLib API asynchronously
func (client *Client) DescribeImageLibWithCallback(request *DescribeImageLibRequest, callback func(response *DescribeImageLibResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageLibResponse
		var err error
		defer close(result)
		response, err = client.DescribeImageLib(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageLibRequest is the request struct for api DescribeImageLib
type DescribeImageLibRequest struct {
	*requests.RpcRequest
	ServiceModule string `position:"Query" name:"ServiceModule"`
	SourceIp      string `position:"Query" name:"SourceIp"`
}

// DescribeImageLibResponse is the response struct for api DescribeImageLib
type DescribeImageLibResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	TotalCount   int        `json:"TotalCount" xml:"TotalCount"`
	ImageLibList []ImageLib `json:"ImageLibList" xml:"ImageLibList"`
}

// CreateDescribeImageLibRequest creates a request to invoke DescribeImageLib API
func CreateDescribeImageLibRequest() (request *DescribeImageLibRequest) {
	request = &DescribeImageLibRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeImageLib", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImageLibResponse creates a response to parse from DescribeImageLib response
func CreateDescribeImageLibResponse() (response *DescribeImageLibResponse) {
	response = &DescribeImageLibResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
