package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKeywordLib invokes the green.DescribeKeywordLib API synchronously
func (client *Client) DescribeKeywordLib(request *DescribeKeywordLibRequest) (response *DescribeKeywordLibResponse, err error) {
	response = CreateDescribeKeywordLibResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKeywordLibWithChan invokes the green.DescribeKeywordLib API asynchronously
func (client *Client) DescribeKeywordLibWithChan(request *DescribeKeywordLibRequest) (<-chan *DescribeKeywordLibResponse, <-chan error) {
	responseChan := make(chan *DescribeKeywordLibResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKeywordLib(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKeywordLibWithCallback invokes the green.DescribeKeywordLib API asynchronously
func (client *Client) DescribeKeywordLibWithCallback(request *DescribeKeywordLibRequest, callback func(response *DescribeKeywordLibResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKeywordLibResponse
		var err error
		defer close(result)
		response, err = client.DescribeKeywordLib(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKeywordLibRequest is the request struct for api DescribeKeywordLib
type DescribeKeywordLibRequest struct {
	*requests.RpcRequest
	ServiceModule string `position:"Query" name:"ServiceModule"`
	SourceIp      string `position:"Query" name:"SourceIp"`
	Lang          string `position:"Query" name:"Lang"`
}

// DescribeKeywordLibResponse is the response struct for api DescribeKeywordLib
type DescribeKeywordLibResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	TotalCount     int          `json:"TotalCount" xml:"TotalCount"`
	KeywordLibList []KeywordLib `json:"KeywordLibList" xml:"KeywordLibList"`
}

// CreateDescribeKeywordLibRequest creates a request to invoke DescribeKeywordLib API
func CreateDescribeKeywordLibRequest() (request *DescribeKeywordLibRequest) {
	request = &DescribeKeywordLibRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeKeywordLib", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeKeywordLibResponse creates a response to parse from DescribeKeywordLib response
func CreateDescribeKeywordLibResponse() (response *DescribeKeywordLibResponse) {
	response = &DescribeKeywordLibResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
