package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOssStockStatus invokes the green.DescribeOssStockStatus API synchronously
func (client *Client) DescribeOssStockStatus(request *DescribeOssStockStatusRequest) (response *DescribeOssStockStatusResponse, err error) {
	response = CreateDescribeOssStockStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOssStockStatusWithChan invokes the green.DescribeOssStockStatus API asynchronously
func (client *Client) DescribeOssStockStatusWithChan(request *DescribeOssStockStatusRequest) (<-chan *DescribeOssStockStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeOssStockStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOssStockStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOssStockStatusWithCallback invokes the green.DescribeOssStockStatus API asynchronously
func (client *Client) DescribeOssStockStatusWithCallback(request *DescribeOssStockStatusRequest, callback func(response *DescribeOssStockStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOssStockStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeOssStockStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOssStockStatusRequest is the request struct for api DescribeOssStockStatus
type DescribeOssStockStatusRequest struct {
	*requests.RpcRequest
	StockTaskId requests.Integer `position:"Query" name:"StockTaskId"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeOssStockStatusResponse is the response struct for api DescribeOssStockStatus
type DescribeOssStockStatusResponse struct {
	*responses.BaseResponse
	RequestId               string   `json:"RequestId" xml:"RequestId"`
	StockStatus             int      `json:"StockStatus" xml:"StockStatus"`
	FinishedTime            string   `json:"FinishedTime" xml:"FinishedTime"`
	ImageTotalCount         int      `json:"ImageTotalCount" xml:"ImageTotalCount"`
	ImagePornCount          int      `json:"ImagePornCount" xml:"ImagePornCount"`
	ImageTerrorismCount     int      `json:"ImageTerrorismCount" xml:"ImageTerrorismCount"`
	ImageAdCount            int      `json:"ImageAdCount" xml:"ImageAdCount"`
	ImageLiveCount          int      `json:"ImageLiveCount" xml:"ImageLiveCount"`
	VideoTotalCount         int      `json:"VideoTotalCount" xml:"VideoTotalCount"`
	VideoPornCount          int      `json:"VideoPornCount" xml:"VideoPornCount"`
	VideoTerrorismCount     int      `json:"VideoTerrorismCount" xml:"VideoTerrorismCount"`
	VideoAdCount            int      `json:"VideoAdCount" xml:"VideoAdCount"`
	VideoLiveCount          int      `json:"VideoLiveCount" xml:"VideoLiveCount"`
	VideoVoiceAntispamCount int      `json:"VideoVoiceAntispamCount" xml:"VideoVoiceAntispamCount"`
	AudioTotalCount         int      `json:"AudioTotalCount" xml:"AudioTotalCount"`
	AudioAntispamCount      int      `json:"AudioAntispamCount" xml:"AudioAntispamCount"`
	SceneList               []string `json:"SceneList" xml:"SceneList"`
	ResouceTypeList         []string `json:"ResouceTypeList" xml:"ResouceTypeList"`
	BucketList              []Bucket `json:"BucketList" xml:"BucketList"`
}

// CreateDescribeOssStockStatusRequest creates a request to invoke DescribeOssStockStatus API
func CreateDescribeOssStockStatusRequest() (request *DescribeOssStockStatusRequest) {
	request = &DescribeOssStockStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeOssStockStatus", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOssStockStatusResponse creates a response to parse from DescribeOssStockStatus response
func CreateDescribeOssStockStatusResponse() (response *DescribeOssStockStatusResponse) {
	response = &DescribeOssStockStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
