package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LiveStreamAsyncScanResults invokes the green.LiveStreamAsyncScanResults API synchronously
func (client *Client) LiveStreamAsyncScanResults(request *LiveStreamAsyncScanResultsRequest) (response *LiveStreamAsyncScanResultsResponse, err error) {
	response = CreateLiveStreamAsyncScanResultsResponse()
	err = client.DoAction(request, response)
	return
}

// LiveStreamAsyncScanResultsWithChan invokes the green.LiveStreamAsyncScanResults API asynchronously
func (client *Client) LiveStreamAsyncScanResultsWithChan(request *LiveStreamAsyncScanResultsRequest) (<-chan *LiveStreamAsyncScanResultsResponse, <-chan error) {
	responseChan := make(chan *LiveStreamAsyncScanResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LiveStreamAsyncScanResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LiveStreamAsyncScanResultsWithCallback invokes the green.LiveStreamAsyncScanResults API asynchronously
func (client *Client) LiveStreamAsyncScanResultsWithCallback(request *LiveStreamAsyncScanResultsRequest, callback func(response *LiveStreamAsyncScanResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LiveStreamAsyncScanResultsResponse
		var err error
		defer close(result)
		response, err = client.LiveStreamAsyncScanResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LiveStreamAsyncScanResultsRequest is the request struct for api LiveStreamAsyncScanResults
type LiveStreamAsyncScanResultsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// LiveStreamAsyncScanResultsResponse is the response struct for api LiveStreamAsyncScanResults
type LiveStreamAsyncScanResultsResponse struct {
	*responses.BaseResponse
}

// CreateLiveStreamAsyncScanResultsRequest creates a request to invoke LiveStreamAsyncScanResults API
func CreateLiveStreamAsyncScanResultsRequest() (request *LiveStreamAsyncScanResultsRequest) {
	request = &LiveStreamAsyncScanResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "LiveStreamAsyncScanResults", "/green/livestream/results", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLiveStreamAsyncScanResultsResponse creates a response to parse from LiveStreamAsyncScanResults response
func CreateLiveStreamAsyncScanResultsResponse() (response *LiveStreamAsyncScanResultsResponse) {
	response = &LiveStreamAsyncScanResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
