package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefundWebSiteInstance invokes the green.RefundWebSiteInstance API synchronously
func (client *Client) RefundWebSiteInstance(request *RefundWebSiteInstanceRequest) (response *RefundWebSiteInstanceResponse, err error) {
	response = CreateRefundWebSiteInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RefundWebSiteInstanceWithChan invokes the green.RefundWebSiteInstance API asynchronously
func (client *Client) RefundWebSiteInstanceWithChan(request *RefundWebSiteInstanceRequest) (<-chan *RefundWebSiteInstanceResponse, <-chan error) {
	responseChan := make(chan *RefundWebSiteInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefundWebSiteInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefundWebSiteInstanceWithCallback invokes the green.RefundWebSiteInstance API asynchronously
func (client *Client) RefundWebSiteInstanceWithCallback(request *RefundWebSiteInstanceRequest, callback func(response *RefundWebSiteInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefundWebSiteInstanceResponse
		var err error
		defer close(result)
		response, err = client.RefundWebSiteInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefundWebSiteInstanceRequest is the request struct for api RefundWebSiteInstance
type RefundWebSiteInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId string `position:"Query" name:"ResourceOwnerId"`
	InstanceId      string `position:"Query" name:"InstanceId"`
}

// RefundWebSiteInstanceResponse is the response struct for api RefundWebSiteInstance
type RefundWebSiteInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRefundWebSiteInstanceRequest creates a request to invoke RefundWebSiteInstance API
func CreateRefundWebSiteInstanceRequest() (request *RefundWebSiteInstanceRequest) {
	request = &RefundWebSiteInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "RefundWebSiteInstance", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefundWebSiteInstanceResponse creates a response to parse from RefundWebSiteInstance response
func CreateRefundWebSiteInstanceResponse() (response *RefundWebSiteInstanceResponse) {
	response = &RefundWebSiteInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
