package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNotificationSetting invokes the green.UpdateNotificationSetting API synchronously
func (client *Client) UpdateNotificationSetting(request *UpdateNotificationSettingRequest) (response *UpdateNotificationSettingResponse, err error) {
	response = CreateUpdateNotificationSettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNotificationSettingWithChan invokes the green.UpdateNotificationSetting API asynchronously
func (client *Client) UpdateNotificationSettingWithChan(request *UpdateNotificationSettingRequest) (<-chan *UpdateNotificationSettingResponse, <-chan error) {
	responseChan := make(chan *UpdateNotificationSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNotificationSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNotificationSettingWithCallback invokes the green.UpdateNotificationSetting API asynchronously
func (client *Client) UpdateNotificationSettingWithCallback(request *UpdateNotificationSettingRequest, callback func(response *UpdateNotificationSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNotificationSettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateNotificationSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNotificationSettingRequest is the request struct for api UpdateNotificationSetting
type UpdateNotificationSettingRequest struct {
	*requests.RpcRequest
	RealtimeMessageList     string           `position:"Query" name:"RealtimeMessageList"`
	ScheduleMessageTime     requests.Integer `position:"Query" name:"ScheduleMessageTime"`
	SourceIp                string           `position:"Query" name:"SourceIp"`
	ReminderModeList        string           `position:"Query" name:"ReminderModeList"`
	Lang                    string           `position:"Query" name:"Lang"`
	ScheduleMessageTimeZone requests.Integer `position:"Query" name:"ScheduleMessageTimeZone"`
}

// UpdateNotificationSettingResponse is the response struct for api UpdateNotificationSetting
type UpdateNotificationSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateNotificationSettingRequest creates a request to invoke UpdateNotificationSetting API
func CreateUpdateNotificationSettingRequest() (request *UpdateNotificationSettingRequest) {
	request = &UpdateNotificationSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateNotificationSetting", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateNotificationSettingResponse creates a response to parse from UpdateNotificationSetting response
func CreateUpdateNotificationSettingResponse() (response *UpdateNotificationSettingResponse) {
	response = &UpdateNotificationSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
