package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VideoAsyncManualScan invokes the green.VideoAsyncManualScan API synchronously
func (client *Client) VideoAsyncManualScan(request *VideoAsyncManualScanRequest) (response *VideoAsyncManualScanResponse, err error) {
	response = CreateVideoAsyncManualScanResponse()
	err = client.DoAction(request, response)
	return
}

// VideoAsyncManualScanWithChan invokes the green.VideoAsyncManualScan API asynchronously
func (client *Client) VideoAsyncManualScanWithChan(request *VideoAsyncManualScanRequest) (<-chan *VideoAsyncManualScanResponse, <-chan error) {
	responseChan := make(chan *VideoAsyncManualScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VideoAsyncManualScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VideoAsyncManualScanWithCallback invokes the green.VideoAsyncManualScan API asynchronously
func (client *Client) VideoAsyncManualScanWithCallback(request *VideoAsyncManualScanRequest, callback func(response *VideoAsyncManualScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VideoAsyncManualScanResponse
		var err error
		defer close(result)
		response, err = client.VideoAsyncManualScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VideoAsyncManualScanRequest is the request struct for api VideoAsyncManualScan
type VideoAsyncManualScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VideoAsyncManualScanResponse is the response struct for api VideoAsyncManualScan
type VideoAsyncManualScanResponse struct {
	*responses.BaseResponse
}

// CreateVideoAsyncManualScanRequest creates a request to invoke VideoAsyncManualScan API
func CreateVideoAsyncManualScanRequest() (request *VideoAsyncManualScanRequest) {
	request = &VideoAsyncManualScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VideoAsyncManualScan", "/green/video/manual/asyncScan", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVideoAsyncManualScanResponse creates a response to parse from VideoAsyncManualScan response
func CreateVideoAsyncManualScanResponse() (response *VideoAsyncManualScanResponse) {
	response = &VideoAsyncManualScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
