package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMultiZoneAvailableRegions invokes the hbase.DescribeMultiZoneAvailableRegions API synchronously
func (client *Client) DescribeMultiZoneAvailableRegions(request *DescribeMultiZoneAvailableRegionsRequest) (response *DescribeMultiZoneAvailableRegionsResponse, err error) {
	response = CreateDescribeMultiZoneAvailableRegionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMultiZoneAvailableRegionsWithChan invokes the hbase.DescribeMultiZoneAvailableRegions API asynchronously
func (client *Client) DescribeMultiZoneAvailableRegionsWithChan(request *DescribeMultiZoneAvailableRegionsRequest) (<-chan *DescribeMultiZoneAvailableRegionsResponse, <-chan error) {
	responseChan := make(chan *DescribeMultiZoneAvailableRegionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMultiZoneAvailableRegions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMultiZoneAvailableRegionsWithCallback invokes the hbase.DescribeMultiZoneAvailableRegions API asynchronously
func (client *Client) DescribeMultiZoneAvailableRegionsWithCallback(request *DescribeMultiZoneAvailableRegionsRequest, callback func(response *DescribeMultiZoneAvailableRegionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMultiZoneAvailableRegionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeMultiZoneAvailableRegions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMultiZoneAvailableRegionsRequest is the request struct for api DescribeMultiZoneAvailableRegions
type DescribeMultiZoneAvailableRegionsRequest struct {
	*requests.RpcRequest
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// DescribeMultiZoneAvailableRegionsResponse is the response struct for api DescribeMultiZoneAvailableRegions
type DescribeMultiZoneAvailableRegionsResponse struct {
	*responses.BaseResponse
	RequestId string                                     `json:"RequestId" xml:"RequestId"`
	Regions   RegionsInDescribeMultiZoneAvailableRegions `json:"Regions" xml:"Regions"`
}

// CreateDescribeMultiZoneAvailableRegionsRequest creates a request to invoke DescribeMultiZoneAvailableRegions API
func CreateDescribeMultiZoneAvailableRegionsRequest() (request *DescribeMultiZoneAvailableRegionsRequest) {
	request = &DescribeMultiZoneAvailableRegionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeMultiZoneAvailableRegions", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMultiZoneAvailableRegionsResponse creates a response to parse from DescribeMultiZoneAvailableRegions response
func CreateDescribeMultiZoneAvailableRegionsResponse() (response *DescribeMultiZoneAvailableRegionsResponse) {
	response = &DescribeMultiZoneAvailableRegionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
