package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EncodeBlindWatermark invokes the imm.EncodeBlindWatermark API synchronously
func (client *Client) EncodeBlindWatermark(request *EncodeBlindWatermarkRequest) (response *EncodeBlindWatermarkResponse, err error) {
	response = CreateEncodeBlindWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// EncodeBlindWatermarkWithChan invokes the imm.EncodeBlindWatermark API asynchronously
func (client *Client) EncodeBlindWatermarkWithChan(request *EncodeBlindWatermarkRequest) (<-chan *EncodeBlindWatermarkResponse, <-chan error) {
	responseChan := make(chan *EncodeBlindWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EncodeBlindWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EncodeBlindWatermarkWithCallback invokes the imm.EncodeBlindWatermark API asynchronously
func (client *Client) EncodeBlindWatermarkWithCallback(request *EncodeBlindWatermarkRequest, callback func(response *EncodeBlindWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EncodeBlindWatermarkResponse
		var err error
		defer close(result)
		response, err = client.EncodeBlindWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EncodeBlindWatermarkRequest is the request struct for api EncodeBlindWatermark
type EncodeBlindWatermarkRequest struct {
	*requests.RpcRequest
	ImageQuality    string `position:"Query" name:"ImageQuality"`
	WatermarkUri    string `position:"Query" name:"WatermarkUri"`
	Project         string `position:"Query" name:"Project"`
	Content         string `position:"Query" name:"Content"`
	WatermarkType   string `position:"Query" name:"WatermarkType"`
	TargetUri       string `position:"Query" name:"TargetUri"`
	Model           string `position:"Query" name:"Model"`
	TargetImageType string `position:"Query" name:"TargetImageType"`
	ImageUri        string `position:"Query" name:"ImageUri"`
}

// EncodeBlindWatermarkResponse is the response struct for api EncodeBlindWatermark
type EncodeBlindWatermarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TargetUri string `json:"TargetUri" xml:"TargetUri"`
	Content   string `json:"Content" xml:"Content"`
}

// CreateEncodeBlindWatermarkRequest creates a request to invoke EncodeBlindWatermark API
func CreateEncodeBlindWatermarkRequest() (request *EncodeBlindWatermarkRequest) {
	request = &EncodeBlindWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "EncodeBlindWatermark", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEncodeBlindWatermarkResponse creates a response to parse from EncodeBlindWatermark response
func CreateEncodeBlindWatermarkResponse() (response *EncodeBlindWatermarkResponse) {
	response = &EncodeBlindWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
