package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetImage invokes the imm.GetImage API synchronously
func (client *Client) GetImage(request *GetImageRequest) (response *GetImageResponse, err error) {
	response = CreateGetImageResponse()
	err = client.DoAction(request, response)
	return
}

// GetImageWithChan invokes the imm.GetImage API asynchronously
func (client *Client) GetImageWithChan(request *GetImageRequest) (<-chan *GetImageResponse, <-chan error) {
	responseChan := make(chan *GetImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetImageWithCallback invokes the imm.GetImage API asynchronously
func (client *Client) GetImageWithCallback(request *GetImageRequest, callback func(response *GetImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetImageResponse
		var err error
		defer close(result)
		response, err = client.GetImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetImageRequest is the request struct for api GetImage
type GetImageRequest struct {
	*requests.RpcRequest
	Project  string `position:"Query" name:"Project"`
	ImageUri string `position:"Query" name:"ImageUri"`
	SetId    string `position:"Query" name:"SetId"`
}

// GetImageResponse is the response struct for api GetImage
type GetImageResponse struct {
	*responses.BaseResponse
	ModifyTime                   string                   `json:"ModifyTime" xml:"ModifyTime"`
	SourceUri                    string                   `json:"SourceUri" xml:"SourceUri"`
	SourceType                   string                   `json:"SourceType" xml:"SourceType"`
	FacesFailReason              string                   `json:"FacesFailReason" xml:"FacesFailReason"`
	CroppingSuggestionStatus     string                   `json:"CroppingSuggestionStatus" xml:"CroppingSuggestionStatus"`
	CroppingSuggestionFailReason string                   `json:"CroppingSuggestionFailReason" xml:"CroppingSuggestionFailReason"`
	RemarksA                     string                   `json:"RemarksA" xml:"RemarksA"`
	AddressFailReason            string                   `json:"AddressFailReason" xml:"AddressFailReason"`
	RemarksB                     string                   `json:"RemarksB" xml:"RemarksB"`
	AddressModifyTime            string                   `json:"AddressModifyTime" xml:"AddressModifyTime"`
	ImageFormat                  string                   `json:"ImageFormat" xml:"ImageFormat"`
	RemarksArrayB                string                   `json:"RemarksArrayB" xml:"RemarksArrayB"`
	TagsFailReason               string                   `json:"TagsFailReason" xml:"TagsFailReason"`
	Exif                         string                   `json:"Exif" xml:"Exif"`
	FacesModifyTime              string                   `json:"FacesModifyTime" xml:"FacesModifyTime"`
	RemarksC                     string                   `json:"RemarksC" xml:"RemarksC"`
	RemarksD                     string                   `json:"RemarksD" xml:"RemarksD"`
	ImageWidth                   int                      `json:"ImageWidth" xml:"ImageWidth"`
	SourcePosition               string                   `json:"SourcePosition" xml:"SourcePosition"`
	RemarksArrayA                string                   `json:"RemarksArrayA" xml:"RemarksArrayA"`
	AddressStatus                string                   `json:"AddressStatus" xml:"AddressStatus"`
	FacesStatus                  string                   `json:"FacesStatus" xml:"FacesStatus"`
	ImageQualityModifyTime       string                   `json:"ImageQualityModifyTime" xml:"ImageQualityModifyTime"`
	RequestId                    string                   `json:"RequestId" xml:"RequestId"`
	TagsModifyTime               string                   `json:"TagsModifyTime" xml:"TagsModifyTime"`
	ExternalId                   string                   `json:"ExternalId" xml:"ExternalId"`
	CreateTime                   string                   `json:"CreateTime" xml:"CreateTime"`
	ImageQualityFailReason       string                   `json:"ImageQualityFailReason" xml:"ImageQualityFailReason"`
	ImageUri                     string                   `json:"ImageUri" xml:"ImageUri"`
	Orientation                  string                   `json:"Orientation" xml:"Orientation"`
	OCRStatus                    string                   `json:"OCRStatus" xml:"OCRStatus"`
	OCRModifyTime                string                   `json:"OCRModifyTime" xml:"OCRModifyTime"`
	CroppingSuggestionModifyTime string                   `json:"CroppingSuggestionModifyTime" xml:"CroppingSuggestionModifyTime"`
	ImageTime                    string                   `json:"ImageTime" xml:"ImageTime"`
	TagsStatus                   string                   `json:"TagsStatus" xml:"TagsStatus"`
	ImageQualityStatus           string                   `json:"ImageQualityStatus" xml:"ImageQualityStatus"`
	ImageHeight                  int                      `json:"ImageHeight" xml:"ImageHeight"`
	OCRFailReason                string                   `json:"OCRFailReason" xml:"OCRFailReason"`
	SetId                        string                   `json:"SetId" xml:"SetId"`
	Location                     string                   `json:"Location" xml:"Location"`
	FileSize                     int                      `json:"FileSize" xml:"FileSize"`
	ImageQuality                 ImageQuality             `json:"ImageQuality" xml:"ImageQuality"`
	Address                      Address                  `json:"Address" xml:"Address"`
	CroppingSuggestion           []CroppingSuggestionItem `json:"CroppingSuggestion" xml:"CroppingSuggestion"`
	Faces                        []FacesItemInGetImage    `json:"Faces" xml:"Faces"`
	Tags                         []TagsItem               `json:"Tags" xml:"Tags"`
	OCR                          []OCRItem                `json:"OCR" xml:"OCR"`
}

// CreateGetImageRequest creates a request to invoke GetImage API
func CreateGetImageRequest() (request *GetImageRequest) {
	request = &GetImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "GetImage", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetImageResponse creates a response to parse from GetImage response
func CreateGetImageResponse() (response *GetImageResponse) {
	response = &GetImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
