package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOTAVerifyJob invokes the iot.CreateOTAVerifyJob API synchronously
func (client *Client) CreateOTAVerifyJob(request *CreateOTAVerifyJobRequest) (response *CreateOTAVerifyJobResponse, err error) {
	response = CreateCreateOTAVerifyJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOTAVerifyJobWithChan invokes the iot.CreateOTAVerifyJob API asynchronously
func (client *Client) CreateOTAVerifyJobWithChan(request *CreateOTAVerifyJobRequest) (<-chan *CreateOTAVerifyJobResponse, <-chan error) {
	responseChan := make(chan *CreateOTAVerifyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOTAVerifyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOTAVerifyJobWithCallback invokes the iot.CreateOTAVerifyJob API asynchronously
func (client *Client) CreateOTAVerifyJobWithCallback(request *CreateOTAVerifyJobRequest, callback func(response *CreateOTAVerifyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOTAVerifyJobResponse
		var err error
		defer close(result)
		response, err = client.CreateOTAVerifyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOTAVerifyJobRequest is the request struct for api CreateOTAVerifyJob
type CreateOTAVerifyJobRequest struct {
	*requests.RpcRequest
	TimeoutInMinutes requests.Integer         `position:"Query" name:"TimeoutInMinutes"`
	NeedConfirm      requests.Boolean         `position:"Query" name:"NeedConfirm"`
	NeedPush         requests.Boolean         `position:"Query" name:"NeedPush"`
	IotInstanceId    string                   `position:"Query" name:"IotInstanceId"`
	Tag              *[]CreateOTAVerifyJobTag `position:"Query" name:"Tag"  type:"Repeated"`
	FirmwareId       string                   `position:"Query" name:"FirmwareId"`
	ProductKey       string                   `position:"Query" name:"ProductKey"`
	ApiProduct       string                   `position:"Body" name:"ApiProduct"`
	ApiRevision      string                   `position:"Body" name:"ApiRevision"`
	TargetDeviceName *[]string                `position:"Query" name:"TargetDeviceName"  type:"Repeated"`
}

// CreateOTAVerifyJobTag is a repeated param struct in CreateOTAVerifyJobRequest
type CreateOTAVerifyJobTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateOTAVerifyJobResponse is the response struct for api CreateOTAVerifyJob
type CreateOTAVerifyJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateCreateOTAVerifyJobRequest creates a request to invoke CreateOTAVerifyJob API
func CreateCreateOTAVerifyJobRequest() (request *CreateOTAVerifyJobRequest) {
	request = &CreateOTAVerifyJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateOTAVerifyJob", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOTAVerifyJobResponse creates a response to parse from CreateOTAVerifyJob response
func CreateCreateOTAVerifyJobResponse() (response *CreateOTAVerifyJobResponse) {
	response = &CreateOTAVerifyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
