package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRule invokes the iot.ListRule API synchronously
func (client *Client) ListRule(request *ListRuleRequest) (response *ListRuleResponse, err error) {
	response = CreateListRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListRuleWithChan invokes the iot.ListRule API asynchronously
func (client *Client) ListRuleWithChan(request *ListRuleRequest) (<-chan *ListRuleResponse, <-chan error) {
	responseChan := make(chan *ListRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRuleWithCallback invokes the iot.ListRule API asynchronously
func (client *Client) ListRuleWithCallback(request *ListRuleRequest, callback func(response *ListRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRuleResponse
		var err error
		defer close(result)
		response, err = client.ListRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRuleRequest is the request struct for api ListRule
type ListRuleRequest struct {
	*requests.RpcRequest
	SearchName      string           `position:"Query" name:"SearchName"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	IotInstanceId   string           `position:"Query" name:"IotInstanceId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	ApiProduct      string           `position:"Body" name:"ApiProduct"`
	ApiRevision     string           `position:"Body" name:"ApiRevision"`
}

// ListRuleResponse is the response struct for api ListRule
type ListRuleResponse struct {
	*responses.BaseResponse
	RequestId    string         `json:"RequestId" xml:"RequestId"`
	Success      bool           `json:"Success" xml:"Success"`
	Code         string         `json:"Code" xml:"Code"`
	ErrorMessage string         `json:"ErrorMessage" xml:"ErrorMessage"`
	Page         int            `json:"Page" xml:"Page"`
	Total        int            `json:"Total" xml:"Total"`
	PageSize     int            `json:"PageSize" xml:"PageSize"`
	Data         DataInListRule `json:"Data" xml:"Data"`
}

// CreateListRuleRequest creates a request to invoke ListRule API
func CreateListRuleRequest() (request *ListRuleRequest) {
	request = &ListRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListRule", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListRuleResponse creates a response to parse from ListRule response
func CreateListRuleResponse() (response *ListRuleResponse) {
	response = &ListRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
