package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckPermission invokes the oam.CheckPermission API synchronously
// api document: https://help.aliyun.com/api/oam/checkpermission.html
func (client *Client) CheckPermission(request *CheckPermissionRequest) (response *CheckPermissionResponse, err error) {
	response = CreateCheckPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// CheckPermissionWithChan invokes the oam.CheckPermission API asynchronously
// api document: https://help.aliyun.com/api/oam/checkpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckPermissionWithChan(request *CheckPermissionRequest) (<-chan *CheckPermissionResponse, <-chan error) {
	responseChan := make(chan *CheckPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckPermissionWithCallback invokes the oam.CheckPermission API asynchronously
// api document: https://help.aliyun.com/api/oam/checkpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckPermissionWithCallback(request *CheckPermissionRequest, callback func(response *CheckPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckPermissionResponse
		var err error
		defer close(result)
		response, err = client.CheckPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckPermissionRequest is the request struct for api CheckPermission
type CheckPermissionRequest struct {
	*requests.RpcRequest
	Resource    string           `position:"Query" name:"Resource"`
	ActionField string           `position:"Query" name:"ActionField"`
	AliUid      requests.Integer `position:"Query" name:"AliUid"`
}

// CheckPermissionResponse is the response struct for api CheckPermission
type CheckPermissionResponse struct {
	*responses.BaseResponse
	Data    bool   `json:"Data" xml:"Data"`
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
}

// CreateCheckPermissionRequest creates a request to invoke CheckPermission API
func CreateCheckPermissionRequest() (request *CheckPermissionRequest) {
	request = &CheckPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "CheckPermission", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckPermissionResponse creates a response to parse from CheckPermission response
func CreateCheckPermissionResponse() (response *CheckPermissionResponse) {
	response = &CheckPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
