package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClassifyVehicleInsurance invokes the objectdet.ClassifyVehicleInsurance API synchronously
func (client *Client) ClassifyVehicleInsurance(request *ClassifyVehicleInsuranceRequest) (response *ClassifyVehicleInsuranceResponse, err error) {
	response = CreateClassifyVehicleInsuranceResponse()
	err = client.DoAction(request, response)
	return
}

// ClassifyVehicleInsuranceWithChan invokes the objectdet.ClassifyVehicleInsurance API asynchronously
func (client *Client) ClassifyVehicleInsuranceWithChan(request *ClassifyVehicleInsuranceRequest) (<-chan *ClassifyVehicleInsuranceResponse, <-chan error) {
	responseChan := make(chan *ClassifyVehicleInsuranceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClassifyVehicleInsurance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClassifyVehicleInsuranceWithCallback invokes the objectdet.ClassifyVehicleInsurance API asynchronously
func (client *Client) ClassifyVehicleInsuranceWithCallback(request *ClassifyVehicleInsuranceRequest, callback func(response *ClassifyVehicleInsuranceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClassifyVehicleInsuranceResponse
		var err error
		defer close(result)
		response, err = client.ClassifyVehicleInsurance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClassifyVehicleInsuranceRequest is the request struct for api ClassifyVehicleInsurance
type ClassifyVehicleInsuranceRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// ClassifyVehicleInsuranceResponse is the response struct for api ClassifyVehicleInsurance
type ClassifyVehicleInsuranceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateClassifyVehicleInsuranceRequest creates a request to invoke ClassifyVehicleInsurance API
func CreateClassifyVehicleInsuranceRequest() (request *ClassifyVehicleInsuranceRequest) {
	request = &ClassifyVehicleInsuranceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "ClassifyVehicleInsurance", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateClassifyVehicleInsuranceResponse creates a response to parse from ClassifyVehicleInsurance response
func CreateClassifyVehicleInsuranceResponse() (response *ClassifyVehicleInsuranceResponse) {
	response = &ClassifyVehicleInsuranceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
