package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVpcEndpoint invokes the privatelink.CreateVpcEndpoint API synchronously
func (client *Client) CreateVpcEndpoint(request *CreateVpcEndpointRequest) (response *CreateVpcEndpointResponse, err error) {
	response = CreateCreateVpcEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVpcEndpointWithChan invokes the privatelink.CreateVpcEndpoint API asynchronously
func (client *Client) CreateVpcEndpointWithChan(request *CreateVpcEndpointRequest) (<-chan *CreateVpcEndpointResponse, <-chan error) {
	responseChan := make(chan *CreateVpcEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVpcEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVpcEndpointWithCallback invokes the privatelink.CreateVpcEndpoint API asynchronously
func (client *Client) CreateVpcEndpointWithCallback(request *CreateVpcEndpointRequest, callback func(response *CreateVpcEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVpcEndpointResponse
		var err error
		defer close(result)
		response, err = client.CreateVpcEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVpcEndpointRequest is the request struct for api CreateVpcEndpoint
type CreateVpcEndpointRequest struct {
	*requests.RpcRequest
	ClientToken         string                   `position:"Query" name:"ClientToken"`
	SecurityGroupId     *[]string                `position:"Query" name:"SecurityGroupId"  type:"Repeated"`
	Zone                *[]CreateVpcEndpointZone `position:"Query" name:"Zone"  type:"Repeated"`
	ServiceName         string                   `position:"Query" name:"ServiceName"`
	DryRun              requests.Boolean         `position:"Query" name:"DryRun"`
	EndpointDescription string                   `position:"Query" name:"EndpointDescription"`
	EndpointName        string                   `position:"Query" name:"EndpointName"`
	VpcId               string                   `position:"Query" name:"VpcId"`
	ServiceId           string                   `position:"Query" name:"ServiceId"`
}

// CreateVpcEndpointZone is a repeated param struct in CreateVpcEndpointRequest
type CreateVpcEndpointZone struct {
	VSwitchId string `name:"VSwitchId"`
	ZoneId    string `name:"ZoneId"`
	Ip        string `name:"ip"`
}

// CreateVpcEndpointResponse is the response struct for api CreateVpcEndpoint
type CreateVpcEndpointResponse struct {
	*responses.BaseResponse
	EndpointStatus         string `json:"EndpointStatus" xml:"EndpointStatus"`
	EndpointName           string `json:"EndpointName" xml:"EndpointName"`
	VpcId                  string `json:"VpcId" xml:"VpcId"`
	RequestId              string `json:"RequestId" xml:"RequestId"`
	EndpointDomain         string `json:"EndpointDomain" xml:"EndpointDomain"`
	ServiceName            string `json:"ServiceName" xml:"ServiceName"`
	EndpointId             string `json:"EndpointId" xml:"EndpointId"`
	Bandwidth              int64  `json:"Bandwidth" xml:"Bandwidth"`
	CreateTime             string `json:"CreateTime" xml:"CreateTime"`
	EndpointBusinessStatus string `json:"EndpointBusinessStatus" xml:"EndpointBusinessStatus"`
	EndpointDescription    string `json:"EndpointDescription" xml:"EndpointDescription"`
	ConnectionStatus       string `json:"ConnectionStatus" xml:"ConnectionStatus"`
	ServiceId              string `json:"ServiceId" xml:"ServiceId"`
}

// CreateCreateVpcEndpointRequest creates a request to invoke CreateVpcEndpoint API
func CreateCreateVpcEndpointRequest() (request *CreateVpcEndpointRequest) {
	request = &CreateVpcEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "CreateVpcEndpoint", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVpcEndpointResponse creates a response to parse from CreateVpcEndpoint response
func CreateCreateVpcEndpointResponse() (response *CreateVpcEndpointResponse) {
	response = &CreateVpcEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
