package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMPURule invokes the rtc.CreateMPURule API synchronously
func (client *Client) CreateMPURule(request *CreateMPURuleRequest) (response *CreateMPURuleResponse, err error) {
	response = CreateCreateMPURuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMPURuleWithChan invokes the rtc.CreateMPURule API asynchronously
func (client *Client) CreateMPURuleWithChan(request *CreateMPURuleRequest) (<-chan *CreateMPURuleResponse, <-chan error) {
	responseChan := make(chan *CreateMPURuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMPURule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMPURuleWithCallback invokes the rtc.CreateMPURule API asynchronously
func (client *Client) CreateMPURuleWithCallback(request *CreateMPURuleRequest, callback func(response *CreateMPURuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMPURuleResponse
		var err error
		defer close(result)
		response, err = client.CreateMPURule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMPURuleRequest is the request struct for api CreateMPURule
type CreateMPURuleRequest struct {
	*requests.RpcRequest
	BackgroundColor requests.Integer `position:"Query" name:"BackgroundColor"`
	CropMode        requests.Integer `position:"Query" name:"CropMode"`
	ChannelPrefix   string           `position:"Query" name:"ChannelPrefix"`
	TaskProfile     string           `position:"Query" name:"TaskProfile"`
	LayoutIds       *[]string        `position:"Query" name:"LayoutIds"  type:"Repeated"`
	ShowLog         string           `position:"Query" name:"ShowLog"`
	PlayDomain      string           `position:"Query" name:"PlayDomain"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	AppId           string           `position:"Query" name:"AppId"`
	MediaEncode     requests.Integer `position:"Query" name:"MediaEncode"`
	CallBack        string           `position:"Query" name:"CallBack"`
}

// CreateMPURuleResponse is the response struct for api CreateMPURule
type CreateMPURuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RuleId    int64  `json:"RuleId" xml:"RuleId"`
}

// CreateCreateMPURuleRequest creates a request to invoke CreateMPURule API
func CreateCreateMPURuleRequest() (request *CreateMPURuleRequest) {
	request = &CreateMPURuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "CreateMPURule", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMPURuleResponse creates a response to parse from CreateMPURule response
func CreateCreateMPURuleResponse() (response *CreateMPURuleResponse) {
	response = &CreateMPURuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
