package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartRecordTask invokes the rtc.StartRecordTask API synchronously
func (client *Client) StartRecordTask(request *StartRecordTaskRequest) (response *StartRecordTaskResponse, err error) {
	response = CreateStartRecordTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StartRecordTaskWithChan invokes the rtc.StartRecordTask API asynchronously
func (client *Client) StartRecordTaskWithChan(request *StartRecordTaskRequest) (<-chan *StartRecordTaskResponse, <-chan error) {
	responseChan := make(chan *StartRecordTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartRecordTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartRecordTaskWithCallback invokes the rtc.StartRecordTask API asynchronously
func (client *Client) StartRecordTaskWithCallback(request *StartRecordTaskRequest, callback func(response *StartRecordTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartRecordTaskResponse
		var err error
		defer close(result)
		response, err = client.StartRecordTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartRecordTaskRequest is the request struct for api StartRecordTask
type StartRecordTaskRequest struct {
	*requests.RpcRequest
	UserPanes    *[]StartRecordTaskUserPanes `position:"Query" name:"UserPanes"  type:"Repeated"`
	TaskId       string                      `position:"Query" name:"TaskId"`
	ShowLog      string                      `position:"Query" name:"ShowLog"`
	OwnerId      requests.Integer            `position:"Query" name:"OwnerId"`
	TemplateId   string                      `position:"Query" name:"TemplateId"`
	SubSpecUsers *[]string                   `position:"Query" name:"SubSpecUsers"  type:"Repeated"`
	AppId        string                      `position:"Query" name:"AppId"`
	ChannelId    string                      `position:"Query" name:"ChannelId"`
}

// StartRecordTaskUserPanes is a repeated param struct in StartRecordTaskRequest
type StartRecordTaskUserPanes struct {
	PaneId     string                   `name:"PaneId"`
	UserId     string                   `name:"UserId"`
	SourceType string                   `name:"SourceType"`
	Images     *[]StartRecordTaskImages `name:"Images" type:"Repeated"`
	Texts      *[]StartRecordTaskTexts  `name:"Texts" type:"Repeated"`
}

// StartRecordTaskImages is a repeated param struct in StartRecordTaskRequest
type StartRecordTaskImages struct {
	Url     string `name:"Url"`
	Display string `name:"Display"`
	X       string `name:"X"`
	Y       string `name:"Y"`
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	ZOrder  string `name:"ZOrder"`
}

// StartRecordTaskTexts is a repeated param struct in StartRecordTaskRequest
type StartRecordTaskTexts struct {
	Text      string `name:"Text"`
	X         string `name:"X"`
	Y         string `name:"Y"`
	FontType  string `name:"FontType"`
	FontSize  string `name:"FontSize"`
	FontColor string `name:"FontColor"`
	ZOrder    string `name:"ZOrder"`
}

// StartRecordTaskResponse is the response struct for api StartRecordTask
type StartRecordTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartRecordTaskRequest creates a request to invoke StartRecordTask API
func CreateStartRecordTaskRequest() (request *StartRecordTaskRequest) {
	request = &StartRecordTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "StartRecordTask", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartRecordTaskResponse creates a response to parse from StartRecordTask response
func CreateStartRecordTaskResponse() (response *StartRecordTaskResponse) {
	response = &StartRecordTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
