package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchEnableJobs invokes the schedulerx2.BatchEnableJobs API synchronously
func (client *Client) BatchEnableJobs(request *BatchEnableJobsRequest) (response *BatchEnableJobsResponse, err error) {
	response = CreateBatchEnableJobsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchEnableJobsWithChan invokes the schedulerx2.BatchEnableJobs API asynchronously
func (client *Client) BatchEnableJobsWithChan(request *BatchEnableJobsRequest) (<-chan *BatchEnableJobsResponse, <-chan error) {
	responseChan := make(chan *BatchEnableJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchEnableJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchEnableJobsWithCallback invokes the schedulerx2.BatchEnableJobs API asynchronously
func (client *Client) BatchEnableJobsWithCallback(request *BatchEnableJobsRequest, callback func(response *BatchEnableJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchEnableJobsResponse
		var err error
		defer close(result)
		response, err = client.BatchEnableJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchEnableJobsRequest is the request struct for api BatchEnableJobs
type BatchEnableJobsRequest struct {
	*requests.RpcRequest
	NamespaceSource string    `position:"Query" name:"NamespaceSource"`
	GroupId         string    `position:"Query" name:"GroupId"`
	Namespace       string    `position:"Query" name:"Namespace"`
	JobIdList       *[]string `position:"Body" name:"JobIdList"  type:"Repeated"`
}

// BatchEnableJobsResponse is the response struct for api BatchEnableJobs
type BatchEnableJobsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateBatchEnableJobsRequest creates a request to invoke BatchEnableJobs API
func CreateBatchEnableJobsRequest() (request *BatchEnableJobsRequest) {
	request = &BatchEnableJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "BatchEnableJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchEnableJobsResponse creates a response to parse from BatchEnableJobs response
func CreateBatchEnableJobsResponse() (response *BatchEnableJobsResponse) {
	response = &BatchEnableJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
