package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteWorkflow invokes the schedulerx2.ExecuteWorkflow API synchronously
func (client *Client) ExecuteWorkflow(request *ExecuteWorkflowRequest) (response *ExecuteWorkflowResponse, err error) {
	response = CreateExecuteWorkflowResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteWorkflowWithChan invokes the schedulerx2.ExecuteWorkflow API asynchronously
func (client *Client) ExecuteWorkflowWithChan(request *ExecuteWorkflowRequest) (<-chan *ExecuteWorkflowResponse, <-chan error) {
	responseChan := make(chan *ExecuteWorkflowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteWorkflow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteWorkflowWithCallback invokes the schedulerx2.ExecuteWorkflow API asynchronously
func (client *Client) ExecuteWorkflowWithCallback(request *ExecuteWorkflowRequest, callback func(response *ExecuteWorkflowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteWorkflowResponse
		var err error
		defer close(result)
		response, err = client.ExecuteWorkflow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteWorkflowRequest is the request struct for api ExecuteWorkflow
type ExecuteWorkflowRequest struct {
	*requests.RpcRequest
	NamespaceSource    string           `position:"Query" name:"NamespaceSource"`
	GroupId            string           `position:"Query" name:"GroupId"`
	Namespace          string           `position:"Query" name:"Namespace"`
	WorkflowId         requests.Integer `position:"Query" name:"WorkflowId"`
	InstanceParameters string           `position:"Query" name:"InstanceParameters"`
}

// ExecuteWorkflowResponse is the response struct for api ExecuteWorkflow
type ExecuteWorkflowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateExecuteWorkflowRequest creates a request to invoke ExecuteWorkflow API
func CreateExecuteWorkflowRequest() (request *ExecuteWorkflowRequest) {
	request = &ExecuteWorkflowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "ExecuteWorkflow", "", "")
	request.Method = requests.GET
	return
}

// CreateExecuteWorkflowResponse creates a response to parse from ExecuteWorkflow response
func CreateExecuteWorkflowResponse() (response *ExecuteWorkflowResponse) {
	response = &ExecuteWorkflowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
