package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExpressSyncShares invokes the sgw.DescribeExpressSyncShares API synchronously
func (client *Client) DescribeExpressSyncShares(request *DescribeExpressSyncSharesRequest) (response *DescribeExpressSyncSharesResponse, err error) {
	response = CreateDescribeExpressSyncSharesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExpressSyncSharesWithChan invokes the sgw.DescribeExpressSyncShares API asynchronously
func (client *Client) DescribeExpressSyncSharesWithChan(request *DescribeExpressSyncSharesRequest) (<-chan *DescribeExpressSyncSharesResponse, <-chan error) {
	responseChan := make(chan *DescribeExpressSyncSharesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExpressSyncShares(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExpressSyncSharesWithCallback invokes the sgw.DescribeExpressSyncShares API asynchronously
func (client *Client) DescribeExpressSyncSharesWithCallback(request *DescribeExpressSyncSharesRequest, callback func(response *DescribeExpressSyncSharesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExpressSyncSharesResponse
		var err error
		defer close(result)
		response, err = client.DescribeExpressSyncShares(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExpressSyncSharesRequest is the request struct for api DescribeExpressSyncShares
type DescribeExpressSyncSharesRequest struct {
	*requests.RpcRequest
	IsExternal     requests.Boolean `position:"Query" name:"IsExternal"`
	ExpressSyncIds string           `position:"Query" name:"ExpressSyncIds"`
	IsCrossRegion  requests.Boolean `position:"Query" name:"IsCrossRegion"`
	SecurityToken  string           `position:"Query" name:"SecurityToken"`
}

// DescribeExpressSyncSharesResponse is the response struct for api DescribeExpressSyncShares
type DescribeExpressSyncSharesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Shares    Shares `json:"Shares" xml:"Shares"`
}

// CreateDescribeExpressSyncSharesRequest creates a request to invoke DescribeExpressSyncShares API
func CreateDescribeExpressSyncSharesRequest() (request *DescribeExpressSyncSharesRequest) {
	request = &DescribeExpressSyncSharesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeExpressSyncShares", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeExpressSyncSharesResponse creates a response to parse from DescribeExpressSyncShares response
func CreateDescribeExpressSyncSharesResponse() (response *DescribeExpressSyncSharesResponse) {
	response = &DescribeExpressSyncSharesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
