package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAvailableBalance invokes the unimkt.QueryAvailableBalance API synchronously
func (client *Client) QueryAvailableBalance(request *QueryAvailableBalanceRequest) (response *QueryAvailableBalanceResponse, err error) {
	response = CreateQueryAvailableBalanceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAvailableBalanceWithChan invokes the unimkt.QueryAvailableBalance API asynchronously
func (client *Client) QueryAvailableBalanceWithChan(request *QueryAvailableBalanceRequest) (<-chan *QueryAvailableBalanceResponse, <-chan error) {
	responseChan := make(chan *QueryAvailableBalanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAvailableBalance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAvailableBalanceWithCallback invokes the unimkt.QueryAvailableBalance API asynchronously
func (client *Client) QueryAvailableBalanceWithCallback(request *QueryAvailableBalanceRequest, callback func(response *QueryAvailableBalanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAvailableBalanceResponse
		var err error
		defer close(result)
		response, err = client.QueryAvailableBalance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAvailableBalanceRequest is the request struct for api QueryAvailableBalance
type QueryAvailableBalanceRequest struct {
	*requests.RpcRequest
	ProxyUserId requests.Integer `position:"Query" name:"ProxyUserId"`
	ChannelId   string           `position:"Query" name:"ChannelId"`
}

// QueryAvailableBalanceResponse is the response struct for api QueryAvailableBalance
type QueryAvailableBalanceResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateQueryAvailableBalanceRequest creates a request to invoke QueryAvailableBalance API
func CreateQueryAvailableBalanceRequest() (request *QueryAvailableBalanceRequest) {
	request = &QueryAvailableBalanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryAvailableBalance", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryAvailableBalanceResponse creates a response to parse from QueryAvailableBalance response
func CreateQueryAvailableBalanceResponse() (response *QueryAvailableBalanceResponse) {
	response = &QueryAvailableBalanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
