package visionai_poc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizePet invokes the visionai_poc.RecognizePet API synchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizepet.html
func (client *Client) RecognizePet(request *RecognizePetRequest) (response *RecognizePetResponse, err error) {
	response = CreateRecognizePetResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizePetWithChan invokes the visionai_poc.RecognizePet API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizepet.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizePetWithChan(request *RecognizePetRequest) (<-chan *RecognizePetResponse, <-chan error) {
	responseChan := make(chan *RecognizePetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizePet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizePetWithCallback invokes the visionai_poc.RecognizePet API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizepet.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizePetWithCallback(request *RecognizePetRequest, callback func(response *RecognizePetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizePetResponse
		var err error
		defer close(result)
		response, err = client.RecognizePet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizePetRequest is the request struct for api RecognizePet
type RecognizePetRequest struct {
	*requests.RpcRequest
	Method   string `position:"Body" name:"Method"`
	ImageUrl string `position:"Body" name:"ImageUrl"`
	Url      string `position:"Body" name:"Url"`
}

// RecognizePetResponse is the response struct for api RecognizePet
type RecognizePetResponse struct {
	*responses.BaseResponse
	Code     string                 `json:"Code" xml:"Code"`
	Success  bool                   `json:"Success" xml:"Success"`
	Message  string                 `json:"Message" xml:"Message"`
	Response ResponseInRecognizePet `json:"Response" xml:"Response"`
}

// CreateRecognizePetRequest creates a request to invoke RecognizePet API
func CreateRecognizePetRequest() (request *RecognizePetRequest) {
	request = &RecognizePetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("visionai-poc", "2020-04-08", "RecognizePet", "", "")
	return
}

// CreateRecognizePetResponse creates a response to parse from RecognizePet response
func CreateRecognizePetResponse() (response *RecognizePetResponse) {
	response = &RecognizePetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
