package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchForbidVsStream invokes the vs.BatchForbidVsStream API synchronously
func (client *Client) BatchForbidVsStream(request *BatchForbidVsStreamRequest) (response *BatchForbidVsStreamResponse, err error) {
	response = CreateBatchForbidVsStreamResponse()
	err = client.DoAction(request, response)
	return
}

// BatchForbidVsStreamWithChan invokes the vs.BatchForbidVsStream API asynchronously
func (client *Client) BatchForbidVsStreamWithChan(request *BatchForbidVsStreamRequest) (<-chan *BatchForbidVsStreamResponse, <-chan error) {
	responseChan := make(chan *BatchForbidVsStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchForbidVsStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchForbidVsStreamWithCallback invokes the vs.BatchForbidVsStream API asynchronously
func (client *Client) BatchForbidVsStreamWithCallback(request *BatchForbidVsStreamRequest, callback func(response *BatchForbidVsStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchForbidVsStreamResponse
		var err error
		defer close(result)
		response, err = client.BatchForbidVsStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchForbidVsStreamRequest is the request struct for api BatchForbidVsStream
type BatchForbidVsStreamRequest struct {
	*requests.RpcRequest
	Channel             string           `position:"Query" name:"Channel"`
	ShowLog             string           `position:"Query" name:"ShowLog"`
	ControlStreamAction string           `position:"Query" name:"ControlStreamAction"`
	ResumeTime          string           `position:"Query" name:"ResumeTime"`
	LiveStreamType      string           `position:"Query" name:"LiveStreamType"`
	DomainName          string           `position:"Query" name:"DomainName"`
	OwnerId             requests.Integer `position:"Query" name:"OwnerId"`
	Oneshot             string           `position:"Query" name:"Oneshot"`
}

// BatchForbidVsStreamResponse is the response struct for api BatchForbidVsStream
type BatchForbidVsStreamResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ForbidResult ForbidResult `json:"ForbidResult" xml:"ForbidResult"`
}

// CreateBatchForbidVsStreamRequest creates a request to invoke BatchForbidVsStream API
func CreateBatchForbidVsStreamRequest() (request *BatchForbidVsStreamRequest) {
	request = &BatchForbidVsStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchForbidVsStream", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchForbidVsStreamResponse creates a response to parse from BatchForbidVsStream response
func CreateBatchForbidVsStreamResponse() (response *BatchForbidVsStreamResponse) {
	response = &BatchForbidVsStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
