package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUnbindDirectories invokes the vs.BatchUnbindDirectories API synchronously
func (client *Client) BatchUnbindDirectories(request *BatchUnbindDirectoriesRequest) (response *BatchUnbindDirectoriesResponse, err error) {
	response = CreateBatchUnbindDirectoriesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUnbindDirectoriesWithChan invokes the vs.BatchUnbindDirectories API asynchronously
func (client *Client) BatchUnbindDirectoriesWithChan(request *BatchUnbindDirectoriesRequest) (<-chan *BatchUnbindDirectoriesResponse, <-chan error) {
	responseChan := make(chan *BatchUnbindDirectoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUnbindDirectories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUnbindDirectoriesWithCallback invokes the vs.BatchUnbindDirectories API asynchronously
func (client *Client) BatchUnbindDirectoriesWithCallback(request *BatchUnbindDirectoriesRequest, callback func(response *BatchUnbindDirectoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUnbindDirectoriesResponse
		var err error
		defer close(result)
		response, err = client.BatchUnbindDirectories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUnbindDirectoriesRequest is the request struct for api BatchUnbindDirectories
type BatchUnbindDirectoriesRequest struct {
	*requests.RpcRequest
	DirectoryId string           `position:"Query" name:"DirectoryId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId    string           `position:"Query" name:"DeviceId"`
}

// BatchUnbindDirectoriesResponse is the response struct for api BatchUnbindDirectories
type BatchUnbindDirectoriesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateBatchUnbindDirectoriesRequest creates a request to invoke BatchUnbindDirectories API
func CreateBatchUnbindDirectoriesRequest() (request *BatchUnbindDirectoriesRequest) {
	request = &BatchUnbindDirectoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchUnbindDirectories", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchUnbindDirectoriesResponse creates a response to parse from BatchUnbindDirectories response
func CreateBatchUnbindDirectoriesResponse() (response *BatchUnbindDirectoriesResponse) {
	response = &BatchUnbindDirectoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
