package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ForbidVsStream invokes the vs.ForbidVsStream API synchronously
func (client *Client) ForbidVsStream(request *ForbidVsStreamRequest) (response *ForbidVsStreamResponse, err error) {
	response = CreateForbidVsStreamResponse()
	err = client.DoAction(request, response)
	return
}

// ForbidVsStreamWithChan invokes the vs.ForbidVsStream API asynchronously
func (client *Client) ForbidVsStreamWithChan(request *ForbidVsStreamRequest) (<-chan *ForbidVsStreamResponse, <-chan error) {
	responseChan := make(chan *ForbidVsStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ForbidVsStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ForbidVsStreamWithCallback invokes the vs.ForbidVsStream API asynchronously
func (client *Client) ForbidVsStreamWithCallback(request *ForbidVsStreamRequest, callback func(response *ForbidVsStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ForbidVsStreamResponse
		var err error
		defer close(result)
		response, err = client.ForbidVsStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ForbidVsStreamRequest is the request struct for api ForbidVsStream
type ForbidVsStreamRequest struct {
	*requests.RpcRequest
	AppName             string           `position:"Query" name:"AppName"`
	StreamName          string           `position:"Query" name:"StreamName"`
	ShowLog             string           `position:"Query" name:"ShowLog"`
	ControlStreamAction string           `position:"Query" name:"ControlStreamAction"`
	ResumeTime          string           `position:"Query" name:"ResumeTime"`
	LiveStreamType      string           `position:"Query" name:"LiveStreamType"`
	DomainName          string           `position:"Query" name:"DomainName"`
	OwnerId             requests.Integer `position:"Query" name:"OwnerId"`
	Oneshot             string           `position:"Query" name:"Oneshot"`
}

// ForbidVsStreamResponse is the response struct for api ForbidVsStream
type ForbidVsStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateForbidVsStreamRequest creates a request to invoke ForbidVsStream API
func CreateForbidVsStreamRequest() (request *ForbidVsStreamRequest) {
	request = &ForbidVsStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "ForbidVsStream", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateForbidVsStreamResponse creates a response to parse from ForbidVsStream response
func CreateForbidVsStreamResponse() (response *ForbidVsStreamResponse) {
	response = &ForbidVsStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
