package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDeviceCapture invokes the vs.ModifyDeviceCapture API synchronously
func (client *Client) ModifyDeviceCapture(request *ModifyDeviceCaptureRequest) (response *ModifyDeviceCaptureResponse, err error) {
	response = CreateModifyDeviceCaptureResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDeviceCaptureWithChan invokes the vs.ModifyDeviceCapture API asynchronously
func (client *Client) ModifyDeviceCaptureWithChan(request *ModifyDeviceCaptureRequest) (<-chan *ModifyDeviceCaptureResponse, <-chan error) {
	responseChan := make(chan *ModifyDeviceCaptureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDeviceCapture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDeviceCaptureWithCallback invokes the vs.ModifyDeviceCapture API asynchronously
func (client *Client) ModifyDeviceCaptureWithCallback(request *ModifyDeviceCaptureRequest, callback func(response *ModifyDeviceCaptureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDeviceCaptureResponse
		var err error
		defer close(result)
		response, err = client.ModifyDeviceCapture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDeviceCaptureRequest is the request struct for api ModifyDeviceCapture
type ModifyDeviceCaptureRequest struct {
	*requests.RpcRequest
	Video   requests.Integer `position:"Query" name:"Video"`
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	Image   requests.Integer `position:"Query" name:"Image"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyDeviceCaptureResponse is the response struct for api ModifyDeviceCapture
type ModifyDeviceCaptureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDeviceCaptureRequest creates a request to invoke ModifyDeviceCapture API
func CreateModifyDeviceCaptureRequest() (request *ModifyDeviceCaptureRequest) {
	request = &ModifyDeviceCaptureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "ModifyDeviceCapture", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDeviceCaptureResponse creates a response to parse from ModifyDeviceCapture response
func CreateModifyDeviceCaptureResponse() (response *ModifyDeviceCaptureResponse) {
	response = &ModifyDeviceCaptureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
