package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartParentPlatform invokes the vs.StartParentPlatform API synchronously
func (client *Client) StartParentPlatform(request *StartParentPlatformRequest) (response *StartParentPlatformResponse, err error) {
	response = CreateStartParentPlatformResponse()
	err = client.DoAction(request, response)
	return
}

// StartParentPlatformWithChan invokes the vs.StartParentPlatform API asynchronously
func (client *Client) StartParentPlatformWithChan(request *StartParentPlatformRequest) (<-chan *StartParentPlatformResponse, <-chan error) {
	responseChan := make(chan *StartParentPlatformResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartParentPlatform(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartParentPlatformWithCallback invokes the vs.StartParentPlatform API asynchronously
func (client *Client) StartParentPlatformWithCallback(request *StartParentPlatformRequest, callback func(response *StartParentPlatformResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartParentPlatformResponse
		var err error
		defer close(result)
		response, err = client.StartParentPlatform(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartParentPlatformRequest is the request struct for api StartParentPlatform
type StartParentPlatformRequest struct {
	*requests.RpcRequest
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// StartParentPlatformResponse is the response struct for api StartParentPlatform
type StartParentPlatformResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateStartParentPlatformRequest creates a request to invoke StartParentPlatform API
func CreateStartParentPlatformRequest() (request *StartParentPlatformRequest) {
	request = &StartParentPlatformRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "StartParentPlatform", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartParentPlatformResponse creates a response to parse from StartParentPlatform response
func CreateStartParentPlatformResponse() (response *StartParentPlatformResponse) {
	response = &StartParentPlatformResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
